/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;

public class RequestItemBuilder
extends AbstractBuilder<RequestItem, RequestItemService> {
    private static final Logger LOG = LogManager.getLogger();
    public static final String REQ_EMAIL = "jsmith@example.com";
    public static final String REQ_NAME = "John Smith";
    public static final String REQ_MESSAGE = "Please send me a copy of this.";
    public static final String REQ_PATH = "test/file";
    private RequestItem requestItem;
    private Item item;
    private Bitstream bitstream;
    private Date decisionDate;
    private boolean accepted;

    protected RequestItemBuilder(Context context) {
        super(context);
    }

    public static RequestItemBuilder createRequestItem(Context ctx, @NotNull Item item, Bitstream bitstream) {
        RequestItemBuilder builder = new RequestItemBuilder(ctx);
        return builder.create(item, bitstream);
    }

    private RequestItemBuilder create(Item item, Bitstream bitstream) {
        this.item = item;
        this.bitstream = bitstream;
        return this;
    }

    public RequestItemBuilder withDecisionDate(Date date) {
        this.decisionDate = date;
        return this;
    }

    public RequestItemBuilder withAcceptRequest(boolean accepted) {
        this.accepted = accepted;
        return this;
    }

    @Override
    public RequestItem build() {
        String token;
        LOG.atDebug().withLocation().log("Building request with item ID {} and bitstream ID {}", new Supplier[]{() -> this.item.getID().toString(), () -> this.bitstream.getID().toString()});
        try {
            token = requestItemService.createRequest(this.context, this.bitstream, this.item, null == this.bitstream, REQ_EMAIL, REQ_NAME, REQ_MESSAGE);
        }
        catch (SQLException ex) {
            return (RequestItem)this.handleException(ex);
        }
        this.requestItem = requestItemService.findByToken(this.context, token);
        this.requestItem.setAccept_request(this.accepted);
        this.requestItem.setDecision_date(this.decisionDate);
        requestItemService.update(this.context, this.requestItem);
        return this.requestItem;
    }

    @Override
    public void cleanup() throws Exception {
        LOG.debug("cleanup()");
        try (Context ctx = new Context();){
            ctx.setDispatcher("noindex");
            ctx.turnOffAuthorisationSystem();
            this.requestItem = (RequestItem)ctx.reloadEntity((ReloadableEntity)this.requestItem);
            if (null != this.requestItem) {
                this.delete(ctx, this.requestItem);
                ctx.complete();
                this.requestItem = null;
            } else {
                LOG.debug("nothing to clean up.");
            }
        }
    }

    @Override
    public void delete(Context context, RequestItem request) throws Exception {
        requestItemService.delete(context, request);
    }

    public static void deleteRequestItem(String token) throws SQLException {
        LOG.atDebug().withLocation().log("Delete RequestItem with token {}", (Object)token);
        try (Context context = new Context();){
            RequestItem request = requestItemService.findByToken(context, token);
            if (null == request) {
                return;
            }
            requestItemService.delete(context, request);
            context.complete();
        }
    }

    @Override
    protected RequestItemService getService() {
        return requestItemService;
    }
}

