/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.ItemComparator;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemComparatorTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(ItemComparatorTest.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    private Item one;
    private Item two;
    private Collection collection;
    private Community owningCommunity;
    private MetadataField metadataField;

    @Override
    @Before
    public void init() {
        try {
            super.init();
            this.context.turnOffAuthorisationSystem();
            MetadataSchema testSchema = this.metadataSchemaService.find(this.context, "dc");
            this.metadataField = this.metadataFieldService.create(this.context, testSchema, "test", "one", null);
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            this.one = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            this.two = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init:" + ex.getMessage()));
        }
        catch (NonUniqueMetadataException ex) {
            log.error("Error in init", (Throwable)ex);
            Assert.fail((String)("Error in init:" + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.metadataValueService.deleteByMetadataField(this.context, this.metadataField);
            this.metadataFieldService.delete(this.context, this.metadataField);
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
            this.context.restoreAuthSystemState();
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("SQL Error in destroy", ex);
            Assert.fail((String)("SQL Error in destroy: " + ex.getMessage()));
        }
        super.destroy();
    }

    @Test
    public void testCompare() throws SQLException {
        ItemComparator ic = new ItemComparator("test", "one", "*", true);
        int result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 0", (result == 0 ? 1 : 0) != 0);
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 1", (result >= 1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 2", (result <= -1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "2");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "0");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "3");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "0");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "-1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "-1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "3");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "5");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*", "3");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*", "4");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.one, "dc", "test", "one", "*");
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.two, "dc", "test", "one", "*");
    }

    @Test
    public void testEquals() {
        ItemComparator ic = new ItemComparator("test", "one", "*", true);
        Assert.assertFalse((String)"testEquals 0", (boolean)ic.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)ic.equals((Object)"test one"));
        ItemComparator target = new ItemComparator("test1", "one", "*", true);
        Assert.assertFalse((String)"testEquals 2", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one1", "*", true);
        Assert.assertFalse((String)"testEquals 3", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one", "es", true);
        Assert.assertFalse((String)"testEquals 4", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test1", "one", "*", false);
        Assert.assertFalse((String)"testEquals 5", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one", "*", true);
        Assert.assertTrue((String)"testEquals 6", (boolean)ic.equals((Object)target));
    }
}

