/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;

public class MockDataProvider
extends AbstractExternalDataProvider {
    private Map<String, ExternalDataObject> mockLookupMap;
    private String sourceIdentifier;

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        ExternalDataObject externalDataObject = this.mockLookupMap.get(id);
        if (externalDataObject == null) {
            return Optional.empty();
        }
        return Optional.of(externalDataObject);
    }

    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        ArrayList<ExternalDataObject> listToReturn = new ArrayList<ExternalDataObject>();
        for (Map.Entry<String, ExternalDataObject> entry : this.mockLookupMap.entrySet()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)entry.getKey(), (CharSequence)query)) continue;
            listToReturn.add(entry.getValue());
        }
        return listToReturn;
    }

    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    public int getNumberOfResults(String query) {
        return this.searchExternalDataObjects(query, 0, 100).size();
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void init() throws IOException {
        this.mockLookupMap = new HashMap<String, ExternalDataObject>();
        ArrayList<String> externalDataObjectsToMake = new ArrayList<String>();
        externalDataObjectsToMake.add("one");
        externalDataObjectsToMake.add("two");
        externalDataObjectsToMake.add("three");
        externalDataObjectsToMake.add("onetwo");
        for (String id : externalDataObjectsToMake) {
            ExternalDataObject externalDataObject = new ExternalDataObject("mock");
            externalDataObject.setId(id);
            externalDataObject.setValue(id);
            externalDataObject.setDisplayValue(id);
            ArrayList<MetadataValueDTO> list = new ArrayList<MetadataValueDTO>();
            list.add(new MetadataValueDTO("dc", "contributor", "author", null, "Donald, Smith"));
            externalDataObject.setMetadata(list);
            this.mockLookupMap.put(id, externalDataObject);
        }
    }
}

