/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.util.List;
import java.util.Optional;
import org.dspace.AbstractDSpaceTest;
import org.dspace.external.factory.ExternalServiceFactory;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenAIREFundingDataProviderTest
extends AbstractDSpaceTest {
    ExternalDataService externalDataService;
    ExternalDataProvider openAIREFundingDataProvider;

    @Before
    public void init() {
        this.externalDataService = ExternalServiceFactory.getInstance().getExternalDataService();
        this.openAIREFundingDataProvider = this.externalDataService.getExternalDataProvider("openAIREFunding");
    }

    @Test
    public void testNumberOfResultsWSingleKeyword() {
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        Assert.assertEquals((String)"openAIREFunding.numberOfResults.query:mock", (long)77L, (long)this.openAIREFundingDataProvider.getNumberOfResults("mock"));
    }

    @Test
    public void testNumberOfResultsWKeywords() {
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        Assert.assertEquals((String)"openAIREFunding.numberOfResults.query:mock+test", (long)77L, (long)this.openAIREFundingDataProvider.getNumberOfResults("mock+test"));
    }

    @Test
    public void testQueryResultsWSingleKeyword() {
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        List results = this.openAIREFundingDataProvider.searchExternalDataObjects("mock", 0, 10);
        Assert.assertEquals((String)"openAIREFunding.searchExternalDataObjects.size", (long)10L, (long)results.size());
    }

    @Test
    public void testQueryResultsWKeywords() {
        String value = "Mushroom Robo-Pic - Development of an autonomous robotic mushroom picking system";
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        List results = this.openAIREFundingDataProvider.searchExternalDataObjects("mock+test", 0, 10);
        Assert.assertEquals((String)"openAIREFunding.searchExternalDataObjects.size", (long)10L, (long)results.size());
        Assert.assertTrue((String)"openAIREFunding.searchExternalDataObjects.first.value", (boolean)value.equals(((ExternalDataObject)results.get(0)).getValue()));
    }

    @Test
    public void testGetDataObject() {
        String id = "aW5mbzpldS1yZXBvL2dyYW50QWdyZWVtZW50L0ZDVC81ODc2LVBQQ0RUSS8xMTAwNjIvUFQ=";
        String value = "Portuguese Wild Mushrooms: Chemical characterization and functional study of antiproliferative and proapoptotic properties in cancer cell lines";
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        Optional result = this.openAIREFundingDataProvider.getExternalDataObject(id);
        Assert.assertTrue((String)"openAIREFunding.getExternalDataObject.exists", (boolean)result.isPresent());
        Assert.assertTrue((String)"openAIREFunding.getExternalDataObject.value", (boolean)value.equals(((ExternalDataObject)result.get()).getValue()));
    }

    @Test
    public void testGetDataObjectWInvalidId() {
        String id = "WRONGID";
        Assert.assertNotNull((String)"openAIREFundingDataProvider is not null", (Object)this.openAIREFundingDataProvider);
        Optional result = this.openAIREFundingDataProvider.getExternalDataObject(id);
        Assert.assertTrue((String)"openAIREFunding.getExternalDataObject.notExists:WRONGID", (boolean)result.isEmpty());
    }
}

