/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.RelationshipType;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.service.OrcidEntityFactoryService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.orcid.jaxb.model.common.ContributorRole;
import org.orcid.jaxb.model.common.FundingContributorRole;
import org.orcid.jaxb.model.common.Iso3166Country;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.common.SequenceType;
import org.orcid.jaxb.model.common.WorkType;
import org.orcid.jaxb.model.v3.release.common.Contributor;
import org.orcid.jaxb.model.v3.release.common.FuzzyDate;
import org.orcid.jaxb.model.v3.release.common.Organization;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.Activity;
import org.orcid.jaxb.model.v3.release.record.ExternalID;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.FundingContributor;
import org.orcid.jaxb.model.v3.release.record.FundingContributors;
import org.orcid.jaxb.model.v3.release.record.Work;

public class OrcidEntityFactoryServiceIT
extends AbstractIntegrationTestWithDatabase {
    private OrcidEntityFactoryService entityFactoryService;
    private Collection orgUnits;
    private Collection publications;
    private Collection projects;

    @Before
    public void setup() {
        this.entityFactoryService = OrcidServiceFactory.getInstance().getOrcidEntityFactoryService();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withTitle("Parent community").build();
        this.orgUnits = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("OrgUnit").build();
        this.publications = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        this.projects = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Project").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testWorkCreation() {
        this.context.turnOffAuthorisationSystem();
        Item publication = ItemBuilder.createItem(this.context, this.publications).withTitle("Test publication").withAuthor("Walter White").withAuthor("Jesse Pinkman").withEditor("Editor").withIssueDate("2021-04-30").withDescriptionAbstract("Publication description").withLanguage("en_US").withType("Book").withIsPartOf("Journal").withDoiIdentifier("doi-id").withScopusIdentifier("scopus-id").build();
        this.context.restoreAuthSystemState();
        Activity activity = this.entityFactoryService.createOrcidObject(this.context, publication);
        MatcherAssert.assertThat((Object)activity, (Matcher)Matchers.instanceOf(Work.class));
        Work work = (Work)activity;
        MatcherAssert.assertThat((Object)work.getJournalTitle(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)work.getJournalTitle().getContent(), (Matcher)Matchers.is((Object)"Journal"));
        MatcherAssert.assertThat((Object)work.getLanguageCode(), (Matcher)Matchers.is((Object)"en"));
        MatcherAssert.assertThat((Object)work.getPublicationDate(), LambdaMatcher.matches(this.date("2021", "04", "30")));
        MatcherAssert.assertThat((Object)work.getShortDescription(), (Matcher)Matchers.is((Object)"Publication description"));
        MatcherAssert.assertThat((Object)work.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getWorkType(), (Matcher)Matchers.is((Object)WorkType.BOOK));
        MatcherAssert.assertThat((Object)work.getWorkTitle(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)work.getWorkTitle().getTitle(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)work.getWorkTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"Test publication"));
        MatcherAssert.assertThat((Object)work.getWorkContributors(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)work.getUrl(), LambdaMatcher.matches(this.urlEndsWith(publication.getHandle())));
        List contributors = work.getWorkContributors().getContributor();
        MatcherAssert.assertThat((Object)contributors, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)contributors, LambdaMatcher.has(this.contributor("Walter White", ContributorRole.AUTHOR, SequenceType.FIRST)));
        MatcherAssert.assertThat((Object)contributors, LambdaMatcher.has(this.contributor("Editor", ContributorRole.EDITOR, SequenceType.FIRST)));
        MatcherAssert.assertThat((Object)contributors, LambdaMatcher.has(this.contributor("Jesse Pinkman", ContributorRole.AUTHOR, SequenceType.ADDITIONAL)));
        MatcherAssert.assertThat((Object)work.getExternalIdentifiers(), (Matcher)Matchers.notNullValue());
        List externalIds = work.getExternalIdentifiers().getExternalIdentifier();
        MatcherAssert.assertThat((Object)externalIds, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("doi", "doi-id")));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("eid", "scopus-id")));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("handle", publication.getHandle())));
    }

    @Test
    public void testEmptyWorkWithUnknownTypeCreation() {
        this.context.turnOffAuthorisationSystem();
        Item publication = ItemBuilder.createItem(this.context, this.publications).withType("TYPE").build();
        this.context.restoreAuthSystemState();
        Activity activity = this.entityFactoryService.createOrcidObject(this.context, publication);
        MatcherAssert.assertThat((Object)activity, (Matcher)Matchers.instanceOf(Work.class));
        Work work = (Work)activity;
        MatcherAssert.assertThat((Object)work.getJournalTitle(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getLanguageCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getPublicationDate(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getShortDescription(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getWorkType(), (Matcher)Matchers.is((Object)WorkType.OTHER));
        MatcherAssert.assertThat((Object)work.getWorkTitle(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getWorkContributors(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)work.getWorkContributors().getContributor(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)work.getExternalIdentifiers(), (Matcher)Matchers.notNullValue());
        List externalIds = work.getExternalIdentifiers().getExternalIdentifier();
        MatcherAssert.assertThat((Object)externalIds, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("handle", publication.getHandle())));
    }

    @Test
    public void testFundingCreation() {
        this.context.turnOffAuthorisationSystem();
        Item orgUnit = ItemBuilder.createItem(this.context, this.orgUnits).withOrgUnitLegalName("4Science").withOrgUnitCountry("IT").withOrgUnitLocality("Milan").withOrgUnitCrossrefIdentifier("12345").build();
        Item projectItem = ItemBuilder.createItem(this.context, this.projects).withTitle("Test funding").withProjectStartDate("2001-03").withProjectEndDate("2010-03-25").withProjectInvestigator("Walter White").withProjectInvestigator("Jesse Pinkman").withProjectAmount("123").withProjectAmountCurrency("EUR").withOtherIdentifier("888-666-444").withIdentifier("000-111-333").withDescription("This is a funding to test orcid mapping").build();
        EntityType projectType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Project").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, orgUnitType, projectType, "isOrgUnitOfProject", "isProjectOfOrgUnit", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, orgUnit, projectItem, isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        Activity activity = this.entityFactoryService.createOrcidObject(this.context, projectItem);
        MatcherAssert.assertThat((Object)activity, (Matcher)Matchers.instanceOf(Funding.class));
        Funding funding = (Funding)activity;
        MatcherAssert.assertThat((Object)funding.getTitle(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)funding.getTitle().getTitle(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)funding.getTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"Test funding"));
        MatcherAssert.assertThat((Object)funding.getStartDate(), LambdaMatcher.matches(this.date("2001", "03", "01")));
        MatcherAssert.assertThat((Object)funding.getEndDate(), LambdaMatcher.matches(this.date("2010", "03", "25")));
        MatcherAssert.assertThat((Object)funding.getDescription(), (Matcher)Matchers.is((Object)"This is a funding to test orcid mapping"));
        MatcherAssert.assertThat((Object)funding.getUrl(), LambdaMatcher.matches(this.urlEndsWith(projectItem.getHandle())));
        MatcherAssert.assertThat((Object)funding.getAmount(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)funding.getAmount().getContent(), (Matcher)Matchers.is((Object)"123"));
        MatcherAssert.assertThat((Object)funding.getAmount().getCurrencyCode(), (Matcher)Matchers.is((Object)"EUR"));
        Organization organization = funding.getOrganization();
        MatcherAssert.assertThat((Object)organization, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)organization.getName(), (Matcher)Matchers.is((Object)"4Science"));
        MatcherAssert.assertThat((Object)organization.getAddress(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)organization.getAddress().getCountry(), (Matcher)Matchers.is((Object)Iso3166Country.IT));
        MatcherAssert.assertThat((Object)organization.getAddress().getCity(), (Matcher)Matchers.is((Object)"Milan"));
        MatcherAssert.assertThat((Object)organization.getDisambiguatedOrganization(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)organization.getDisambiguatedOrganization().getDisambiguatedOrganizationIdentifier(), (Matcher)Matchers.is((Object)"12345"));
        MatcherAssert.assertThat((Object)organization.getDisambiguatedOrganization().getDisambiguationSource(), (Matcher)Matchers.is((Object)"FUNDREF"));
        FundingContributors fundingContributors = funding.getContributors();
        MatcherAssert.assertThat((Object)fundingContributors, (Matcher)Matchers.notNullValue());
        List contributors = fundingContributors.getContributor();
        MatcherAssert.assertThat((Object)contributors, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)contributors, LambdaMatcher.has(this.fundingContributor("Walter White", FundingContributorRole.LEAD)));
        MatcherAssert.assertThat((Object)contributors, LambdaMatcher.has(this.fundingContributor("Jesse Pinkman", FundingContributorRole.LEAD)));
        MatcherAssert.assertThat((Object)funding.getExternalIdentifiers(), (Matcher)Matchers.notNullValue());
        List externalIds = funding.getExternalIdentifiers().getExternalIdentifier();
        MatcherAssert.assertThat((Object)externalIds, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("other-id", "888-666-444")));
        MatcherAssert.assertThat((Object)externalIds, LambdaMatcher.has(this.selfExternalId("grant_number", "000-111-333")));
    }

    private Predicate<ExternalID> selfExternalId(String type, String value) {
        return this.externalId(type, value, Relationship.SELF);
    }

    private Predicate<ExternalID> externalId(String type, String value, Relationship relationship) {
        return externalId -> externalId.getRelationship() == relationship && type.equals(externalId.getType()) && value.equals(externalId.getValue());
    }

    private Predicate<Contributor> contributor(String name, ContributorRole role, SequenceType sequence) {
        return contributor -> contributor.getCreditName().getContent().equals(name) && role.equals((Object)contributor.getContributorAttributes().getContributorRole()) && contributor.getContributorAttributes().getContributorSequence() == sequence;
    }

    private Predicate<FundingContributor> fundingContributor(String name, FundingContributorRole role) {
        return contributor -> contributor.getCreditName().getContent().equals(name) && role.equals((Object)contributor.getContributorAttributes().getContributorRole());
    }

    private Predicate<? super FuzzyDate> date(String year, String month, String days) {
        return date -> date != null && year.equals(date.getYear().getValue()) && month.equals(date.getMonth().getValue()) && days.equals(date.getDay().getValue());
    }

    private Predicate<Url> urlEndsWith(String handle) {
        return url -> url != null && url.getValue() != null && StringUtils.endsWith((String)url.getValue(), (String)handle);
    }
}

