/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.factory.OrcidProfileSectionFactory;
import org.dspace.orcid.service.OrcidProfileSectionFactoryService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.orcid.jaxb.model.common.Iso3166Country;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.v3.release.record.Address;
import org.orcid.jaxb.model.v3.release.record.Keyword;
import org.orcid.jaxb.model.v3.release.record.OtherName;
import org.orcid.jaxb.model.v3.release.record.PersonExternalIdentifier;
import org.orcid.jaxb.model.v3.release.record.ResearcherUrl;

public class OrcidProfileSectionFactoryServiceIT
extends AbstractIntegrationTestWithDatabase {
    private OrcidProfileSectionFactoryService profileSectionFactoryService;
    private ItemService itemService;
    private Collection collection;

    @Before
    public void setup() {
        this.profileSectionFactoryService = OrcidServiceFactory.getInstance().getOrcidProfileSectionFactoryService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withTitle("Parent community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testAddressCreation() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withPersonCountry("IT").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "person.country", 0));
        Object orcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.COUNTRY);
        MatcherAssert.assertThat((Object)orcidObject, (Matcher)Matchers.instanceOf(Address.class));
        Address address = (Address)orcidObject;
        MatcherAssert.assertThat((Object)address.getCountry(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)address.getCountry().getValue(), (Matcher)Matchers.is((Object)Iso3166Country.IT));
    }

    @Test
    public void testAddressMetadataSignatureGeneration() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withPersonCountry("IT").build();
        this.context.restoreAuthSystemState();
        OrcidProfileSectionFactory countryFactory = this.getFactory(item, OrcidProfileSectionType.COUNTRY);
        List signatures = countryFactory.getMetadataSignatures(this.context, item);
        MatcherAssert.assertThat((Object)signatures, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)countryFactory.getDescription(this.context, item, (String)signatures.get(0)), (Matcher)Matchers.is((Object)"IT"));
    }

    @Test
    public void testExternalIdentifiersCreation() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withScopusAuthorIdentifier("SCOPUS-123456").withResearcherIdentifier("R-ID-01").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "person.identifier.scopus-author-id", 0));
        Object firstOrcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.EXTERNAL_IDS);
        MatcherAssert.assertThat((Object)firstOrcidObject, (Matcher)Matchers.instanceOf(PersonExternalIdentifier.class));
        MatcherAssert.assertThat((Object)((PersonExternalIdentifier)firstOrcidObject), LambdaMatcher.matches(this.hasTypeAndValue("SCOPUS", "SCOPUS-123456")));
        values = List.of(this.getMetadata(item, "person.identifier.rid", 0));
        Object secondOrcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.EXTERNAL_IDS);
        MatcherAssert.assertThat((Object)secondOrcidObject, (Matcher)Matchers.instanceOf(PersonExternalIdentifier.class));
        MatcherAssert.assertThat((Object)((PersonExternalIdentifier)secondOrcidObject), LambdaMatcher.matches(this.hasTypeAndValue("RID", "R-ID-01")));
    }

    @Test
    public void testExternalIdentifiersGeneration() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withScopusAuthorIdentifier("SCOPUS-123456").withResearcherIdentifier("R-ID-01").build();
        this.context.restoreAuthSystemState();
        OrcidProfileSectionFactory externalIdsFactory = this.getFactory(item, OrcidProfileSectionType.EXTERNAL_IDS);
        List signatures = externalIdsFactory.getMetadataSignatures(this.context, item);
        MatcherAssert.assertThat((Object)signatures, (Matcher)Matchers.hasSize((int)2));
        List descriptions = signatures.stream().map(signature -> externalIdsFactory.getDescription(this.context, item, signature)).collect(Collectors.toList());
        MatcherAssert.assertThat(descriptions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"SCOPUS-123456", "R-ID-01"}));
    }

    @Test
    public void testResearcherUrlsCreation() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withUriIdentifier("www.test.com").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "dc.identifier.uri", 0));
        Object orcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.RESEARCHER_URLS);
        MatcherAssert.assertThat((Object)orcidObject, (Matcher)Matchers.instanceOf(ResearcherUrl.class));
        MatcherAssert.assertThat((Object)((ResearcherUrl)orcidObject), LambdaMatcher.matches(this.hasUrl("www.test.com")));
    }

    @Test
    public void testKeywordsCreation() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withSubject("Subject").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "dc.subject", 0));
        Object orcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.KEYWORDS);
        MatcherAssert.assertThat((Object)orcidObject, (Matcher)Matchers.instanceOf(Keyword.class));
        MatcherAssert.assertThat((Object)((Keyword)orcidObject), LambdaMatcher.matches(this.hasContent("Subject")));
    }

    @Test
    public void testOtherNamesCreation() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test profile").withVariantName("Variant name").withVernacularName("Vernacular name").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "person.name.variant", 0));
        Object orcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.OTHER_NAMES);
        MatcherAssert.assertThat((Object)orcidObject, (Matcher)Matchers.instanceOf(OtherName.class));
        MatcherAssert.assertThat((Object)((OtherName)orcidObject), LambdaMatcher.matches(this.hasValue("Variant name")));
        values = List.of(this.getMetadata(item, "person.name.translated", 0));
        orcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.OTHER_NAMES);
        MatcherAssert.assertThat((Object)orcidObject, (Matcher)Matchers.instanceOf(OtherName.class));
        MatcherAssert.assertThat((Object)((OtherName)orcidObject), LambdaMatcher.matches(this.hasValue("Vernacular name")));
    }

    private MetadataValue getMetadata(Item item, String metadataField, int place) {
        List values = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataField);
        MatcherAssert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(place)));
        return (MetadataValue)values.get(place);
    }

    private Predicate<PersonExternalIdentifier> hasTypeAndValue(String type, String value) {
        return identifier -> value.equals(identifier.getValue()) && type.equals(identifier.getType()) && identifier.getRelationship() == Relationship.SELF && identifier.getUrl() != null && value.equals(identifier.getUrl().getValue());
    }

    private Predicate<ResearcherUrl> hasUrl(String url) {
        return researcherUrl -> researcherUrl.getUrl() != null && url.equals(researcherUrl.getUrl().getValue());
    }

    private Predicate<Keyword> hasContent(String value) {
        return keyword -> value.equals(keyword.getContent());
    }

    private Predicate<OtherName> hasValue(String value) {
        return name -> value.equals(name.getContent());
    }

    private OrcidProfileSectionFactory getFactory(Item item, OrcidProfileSectionType sectionType) {
        return (OrcidProfileSectionFactory)this.profileSectionFactoryService.findBySectionType(sectionType).orElseThrow(() -> new IllegalStateException("No profile section factory of type " + sectionType));
    }
}

