/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.MaxMind;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Traits;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.dspace.solr.MockSolrServer;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class MockSolrLoggerServiceImpl
extends SolrLoggerServiceImpl
implements InitializingBean,
DisposableBean {
    private MockSolrServer mockSolrServer;

    public void afterPropertiesSet() throws Exception {
        this.mockSolrServer = new MockSolrServer("statistics");
        this.solr = this.mockSolrServer.getSolrServer();
        DatabaseReader reader = (DatabaseReader)Mockito.mock(DatabaseReader.class);
        Mockito.lenient().when((Object)reader.city((InetAddress)ArgumentMatchers.any(InetAddress.class))).thenReturn((Object)this.mockCityResponse());
        this.locationService = reader;
    }

    private CityResponse mockCityResponse() {
        ArrayList<String> cityLocales = new ArrayList<String>(Collections.singleton("en"));
        HashMap<String, String> cityNames = new HashMap<String, String>();
        cityNames.put("en", "New York");
        City city = new City(cityLocales, Integer.valueOf(1), Integer.valueOf(1), cityNames);
        ArrayList<String> countryNames = new ArrayList<String>(Collections.singleton("United States"));
        Country country = new Country(countryNames, Integer.valueOf(1), Integer.valueOf(1), "US", new HashMap());
        Location location = new Location(Integer.valueOf(1), Integer.valueOf(1), Double.valueOf(40.760498), Double.valueOf(-73.9933), Integer.valueOf(501), Integer.valueOf(1), "EST");
        Postal postal = new Postal("10036", Integer.valueOf(1));
        return new CityResponse(city, new Continent(), country, location, new MaxMind(), postal, country, new RepresentedCountry(), new ArrayList(0), new Traits());
    }

    public void reset() {
        this.mockSolrServer.reset();
    }

    public void destroy() throws Exception {
        this.mockSolrServer.destroy();
    }
}

