/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.statistics.export.IrusExportUsageEventListener;
import org.dspace.statistics.export.OpenURLTracker;
import org.dspace.statistics.export.factory.OpenURLTrackerLoggerServiceFactory;
import org.dspace.statistics.export.service.FailedOpenURLTrackerService;
import org.dspace.usage.UsageEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITIrusExportUsageEventListener
extends AbstractIntegrationTestWithDatabase {
    private static final Logger log = LogManager.getLogger();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected FailedOpenURLTrackerService failedOpenURLTrackerService = OpenURLTrackerLoggerServiceFactory.getInstance().getOpenUrlTrackerLoggerService();
    protected ArrayList testProcessedUrls = (ArrayList)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("testProcessedUrls", ArrayList.class);
    private final IrusExportUsageEventListener exportUsageEventListener = (IrusExportUsageEventListener)DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(IrusExportUsageEventListener.class).get(0);
    private Item item;
    private Item itemNotToBeProcessed;
    private Bitstream bitstream;
    private Bitstream bitstreamNotToBeProcessed;
    private EntityType entityType;
    private Community community;
    private Collection collection;
    private String encodedUrl;
    private String encodedUIUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("irus.statistics.tracker.enabled", (Object)true);
        this.configurationService.setProperty("irus.statistics.tracker.type-field", (Object)"dc.type");
        this.configurationService.setProperty("irus.statistics.tracker.type-value", (Object)"Excluded type");
        this.context.turnOffAuthorisationSystem();
        try {
            this.entityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
            this.community = CommunityBuilder.createCommunity(this.context).build();
            this.collection = CollectionBuilder.createCollection(this.context, this.community).withEntityType(this.entityType.getLabel()).build();
            this.item = ItemBuilder.createItem(this.context, this.collection).build();
            File f = new File(testProps.get("test.bitstream").toString());
            this.bitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)new FileInputStream(f)).build();
            this.itemNotToBeProcessed = ItemBuilder.createItem(this.context, this.collection).withType("Excluded type").build();
            File itemNotToBeProcessedFile = new File(testProps.get("test.bitstream").toString());
            this.bitstreamNotToBeProcessed = BitstreamBuilder.createBitstream(this.context, this.itemNotToBeProcessed, (InputStream)new FileInputStream(itemNotToBeProcessedFile)).build();
            String dspaceUrl = this.configurationService.getProperty("dspace.server.url");
            this.encodedUrl = URLEncoder.encode(dspaceUrl, "UTF-8");
            String dspaceUIUrl = this.configurationService.getProperty("dspace.ui.url");
            this.encodedUIUrl = URLEncoder.encode(dspaceUIUrl, "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void destroy() throws Exception {
        try {
            this.context.turnOffAuthorisationSystem();
            List all = this.failedOpenURLTrackerService.findAll(this.context);
            for (OpenURLTracker tracker : all) {
                this.failedOpenURLTrackerService.remove(this.context, tracker);
            }
            this.testProcessedUrls.clear();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.context.complete();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        super.destroy();
    }

    @Test
    public void testReceiveEventOnItemThatShouldBeProcessed() throws UnsupportedEncodingException, SQLException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"client-ip");
        Mockito.when((Object)request.getHeader(ArgumentMatchers.anyString())).thenReturn(null);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.item);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        String regex = "https://irus.jisc.ac.uk/counter/test/\\?url_ver=Z39.88-2004&req_id=" + URLEncoder.encode(request.getRemoteAddr(), "UTF-8") + "&req_dat=&rft.artnum=oai%3Alocalhost%3A" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rfr_dat=&rfr_id=localhost&url_tim=.*?&svc_dat=" + this.encodedUIUrl + "%2Fhandle%2F" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rft_dat=Investigation";
        boolean isMatch = this.matchesString(String.valueOf(this.testProcessedUrls.get(0)), regex);
        Assert.assertEquals((long)1L, (long)this.testProcessedUrls.size());
        Assert.assertTrue((boolean)isMatch);
        Assert.assertEquals((long)0L, (long)all.size());
    }

    @Test
    public void testReceiveEventOnItemThatShouldBeProcessedFailed() throws SQLException, UnsupportedEncodingException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"client-ip-fail");
        Mockito.when((Object)request.getHeader(ArgumentMatchers.anyString())).thenReturn(null);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.item);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        String regex = "https://irus.jisc.ac.uk/counter/test/\\?url_ver=Z39.88-2004&req_id=" + URLEncoder.encode(request.getRemoteAddr(), "UTF-8") + "&req_dat=&rft.artnum=oai%3Alocalhost%3A" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rfr_dat=&rfr_id=localhost&url_tim=.*?&svc_dat=" + this.encodedUIUrl + "%2Fhandle%2F" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rft_dat=Investigation";
        boolean isMatch = this.matchesString(((OpenURLTracker)all.get(0)).getUrl(), regex);
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertTrue((boolean)isMatch);
    }

    @Test
    public void testReceiveEventOnItemThatShouldNotBeProcessed() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.itemNotToBeProcessed);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", "*");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", null, "OrgUnit");
        this.itemService.update(this.context, (DSpaceObject)this.item);
        this.context.restoreAuthSystemState();
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
        Assert.assertEquals((long)0L, (long)all.size());
    }

    @Test
    public void testReceiveEventOnBitstreamThatShouldBeProcessed() throws SQLException, UnsupportedEncodingException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"client-ip");
        Mockito.when((Object)request.getHeader(ArgumentMatchers.anyString())).thenReturn(null);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.bitstream);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        String regex = "https://irus.jisc.ac.uk/counter/test/\\?url_ver=Z39.88-2004&req_id=" + URLEncoder.encode(request.getRemoteAddr(), "UTF-8") + "&req_dat=&rft.artnum=oai%3Alocalhost%3A" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rfr_dat=&rfr_id=localhost&url_tim=.*?&svc_dat=" + this.encodedUrl + "%2Fapi%2Fcore%2Fbitstreams%2F" + this.bitstream.getID() + "%2Fcontent&rft_dat=Request";
        boolean isMatch = this.matchesString(String.valueOf(this.testProcessedUrls.get(0)), regex);
        Assert.assertEquals((long)1L, (long)this.testProcessedUrls.size());
        Assert.assertTrue((boolean)isMatch);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)0L, (long)all.size());
    }

    @Test
    public void testReceiveEventOnBitstreamThatShouldBeProcessedFail() throws UnsupportedEncodingException, SQLException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"client-ip-fail");
        Mockito.when((Object)request.getHeader(ArgumentMatchers.anyString())).thenReturn(null);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.bitstream);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        String regex = "https://irus.jisc.ac.uk/counter/test/\\?url_ver=Z39.88-2004&req_id=" + URLEncoder.encode(request.getRemoteAddr(), "UTF-8") + "&req_dat=&rft.artnum=oai%3Alocalhost%3A" + URLEncoder.encode(this.item.getHandle(), "UTF-8") + "&rfr_dat=&rfr_id=localhost&url_tim=.*?&svc_dat=" + this.encodedUrl + "%2Fapi%2Fcore%2Fbitstreams%2F" + this.bitstream.getID() + "%2Fcontent&rft_dat=Request";
        boolean isMatch = this.matchesString(((OpenURLTracker)all.get(0)).getUrl(), regex);
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)true, (Object)isMatch);
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
    }

    @Test
    public void testReceiveEventOnBitstreamThatShouldNotBeProcessed() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"client-ip-fail");
        Mockito.when((Object)request.getHeader(ArgumentMatchers.anyString())).thenReturn(null);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.bitstreamNotToBeProcessed);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", "*");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", null, "OrgUnit");
        this.itemService.update(this.context, (DSpaceObject)this.item);
        this.context.restoreAuthSystemState();
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)0L, (long)all.size());
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
    }

    @Test
    public void testReceiveEventOnNonRelevantObject() throws SQLException {
        Mockito.mock(HttpServletRequest.class);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getObject()).thenReturn((Object)this.community);
        Mockito.when((Object)usageEvent.getContext()).thenReturn((Object)new Context());
        this.exportUsageEventListener.receiveEvent((Event)usageEvent);
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)0L, (long)all.size());
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
    }

    private boolean matchesString(String string, String regex) {
        Pattern p = Pattern.compile(regex);
        return p.matcher(string).matches();
    }
}

