/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.curate.Utils;
import org.dspace.storage.bitstore.S3BitStoreService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class S3BitStoreServiceTest
extends AbstractUnitTest {
    private S3BitStoreService s3BitStoreService;
    @Mock
    private AmazonS3Client s3Service;
    @Mock
    private TransferManager tm;
    @Mock
    private Bitstream bitstream;
    @Mock
    private Bitstream externalBitstream;

    @Before
    public void setUp() throws Exception {
        this.s3BitStoreService = new S3BitStoreService((AmazonS3)this.s3Service, this.tm);
    }

    private Supplier<AmazonS3> mockedServiceSupplier() {
        return () -> this.s3Service;
    }

    @Test
    public void givenBucketWhenInitThenUsesSameBucket() throws IOException {
        String bucketName = "Bucket0";
        this.s3BitStoreService.setBucketName(bucketName);
        Mockito.when((Object)this.s3Service.doesBucketExist(bucketName)).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
        this.s3BitStoreService.init();
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service)).doesBucketExist(bucketName);
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service, (VerificationMode)Mockito.times((int)1))).createBucket(bucketName);
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsAccessKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsSecretKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void givenEmptyBucketWhenInitThenUsesDefaultBucket() throws IOException {
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getBucketName(), (Matcher)Matchers.isEmptyOrNullString());
        Mockito.when((Object)this.s3Service.doesBucketExist(ArgumentMatchers.startsWith((String)"dspace-asset-"))).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
        this.s3BitStoreService.init();
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service, (VerificationMode)Mockito.times((int)1))).createBucket(ArgumentMatchers.startsWith((String)"dspace-asset-"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getBucketName(), (Matcher)Matchers.startsWith((String)"dspace-asset-"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsAccessKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsSecretKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void givenAccessKeysWhenInitThenVerifiesCorrectBuilderCreation() throws IOException {
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsAccessKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsSecretKey(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getBucketName(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
        Mockito.when((Object)this.s3Service.doesBucketExist(ArgumentMatchers.startsWith((String)"dspace-asset-"))).thenReturn((Object)false);
        String awsAccessKey = "ACCESS_KEY";
        String awsSecretKey = "SECRET_KEY";
        this.s3BitStoreService.setAwsAccessKey("ACCESS_KEY");
        this.s3BitStoreService.setAwsSecretKey("SECRET_KEY");
        try (MockedStatic mockedS3BitStore = Mockito.mockStatic(S3BitStoreService.class);){
            mockedS3BitStore.when(() -> S3BitStoreService.amazonClientBuilderBy((Regions)((Regions)ArgumentMatchers.any(Regions.class)), (AWSCredentials)((AWSCredentials)ArgumentMatchers.argThat(credentials -> "ACCESS_KEY".equals(credentials.getAWSAccessKeyId()) && "SECRET_KEY".equals(credentials.getAWSSecretKey()))))).thenReturn(this.mockedServiceSupplier());
            this.s3BitStoreService.init();
            mockedS3BitStore.verify(() -> S3BitStoreService.amazonClientBuilderBy((Regions)((Regions)ArgumentMatchers.any(Regions.class)), (AWSCredentials)((AWSCredentials)ArgumentMatchers.argThat(credentials -> "ACCESS_KEY".equals(credentials.getAWSAccessKeyId()) && "SECRET_KEY".equals(credentials.getAWSSecretKey())))));
        }
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service, (VerificationMode)Mockito.times((int)1))).createBucket(ArgumentMatchers.startsWith((String)"dspace-asset-"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getBucketName(), (Matcher)Matchers.startsWith((String)"dspace-asset-"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsAccessKey(), (Matcher)Matchers.equalTo((Object)"ACCESS_KEY"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsSecretKey(), (Matcher)Matchers.equalTo((Object)"SECRET_KEY"));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getAwsRegionName(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void givenBucketBitStreamIdInputStreamWhenRetrievingFromS3ThenUsesBucketBitStreamId() throws IOException {
        String bucketName = "BucketTest";
        String bitStreamId = "BitStreamId";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        S3Object object = (S3Object)Mockito.mock(S3Object.class);
        S3ObjectInputStream inputStream = (S3ObjectInputStream)Mockito.mock(S3ObjectInputStream.class);
        Mockito.when((Object)object.getObjectContent()).thenReturn((Object)inputStream);
        Mockito.when((Object)this.s3Service.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenReturn((Object)object);
        this.s3BitStoreService.init();
        MatcherAssert.assertThat((Object)this.s3BitStoreService.get(this.bitstream), (Matcher)Matchers.equalTo((Object)inputStream));
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service)).getObject((GetObjectRequest)ArgumentMatchers.argThat(request -> bucketName.contentEquals(request.getBucketName()) && bitStreamId.contentEquals(request.getKey())));
    }

    @Test
    public void givenBucketBitStreamIdWhenNothingFoundOnS3ThenReturnsNull() throws IOException {
        String bucketName = "BucketTest";
        String bitStreamId = "BitStreamId";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        Mockito.when((Object)this.s3Service.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenReturn(null);
        this.s3BitStoreService.init();
        MatcherAssert.assertThat((Object)this.s3BitStoreService.get(this.bitstream), (Matcher)Matchers.nullValue());
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service)).getObject((GetObjectRequest)ArgumentMatchers.argThat(request -> bucketName.contentEquals(request.getBucketName()) && bitStreamId.contentEquals(request.getKey())));
    }

    @Test
    public void givenSubFolderWhenRequestsItemFromS3ThenTheIdentifierShouldHaveProperPath() throws IOException {
        String bucketName = "BucketTest";
        String bitStreamId = "012345";
        String subfolder = "/test/DSpace7/";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        this.s3BitStoreService.setSubfolder(subfolder);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        S3Object object = (S3Object)Mockito.mock(S3Object.class);
        S3ObjectInputStream inputStream = (S3ObjectInputStream)Mockito.mock(S3ObjectInputStream.class);
        Mockito.when((Object)object.getObjectContent()).thenReturn((Object)inputStream);
        Mockito.when((Object)this.s3Service.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenReturn((Object)object);
        this.s3BitStoreService.init();
        MatcherAssert.assertThat((Object)this.s3BitStoreService.get(this.bitstream), (Matcher)Matchers.equalTo((Object)inputStream));
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service)).getObject((GetObjectRequest)ArgumentMatchers.argThat(request -> bucketName.equals(request.getBucketName()) && request.getKey().startsWith(subfolder) && request.getKey().contains(bitStreamId) && !request.getKey().contains(File.separator + File.separator)));
    }

    @Test
    public void handleRegisteredIdentifierPrefixInS3() {
        String trueBitStreamId = "012345";
        Objects.requireNonNull(this.s3BitStoreService);
        String registeredBitstreamId = "-R" + trueBitStreamId;
        Assert.assertTrue((boolean)this.s3BitStoreService.isRegisteredBitstream(registeredBitstreamId));
    }

    @Test
    public void stripRegisteredBitstreamPrefixWhenCalculatingPath() {
        String s3Path = "UNIQUE_S3_PATH/test/bitstream.pdf";
        Objects.requireNonNull(this.s3BitStoreService);
        String registeredBitstreamId = "-R" + s3Path;
        String relativeRegisteredPath = this.s3BitStoreService.getRelativePath(registeredBitstreamId);
        Assert.assertEquals((Object)s3Path, (Object)relativeRegisteredPath);
    }

    @Test
    public void givenBitStreamIdentifierLongerThanPossibleWhenIntermediatePathIsComputedThenIsSplittedAndTruncated() {
        String path = "01234567890123456789";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierShorterThanAFolderLengthWhenIntermediatePathIsComputedThenIsSingleFolder() {
        String path = "0";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "0" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenPartialBitStreamIdentifierWhenIntermediatePathIsComputedThenIsCompletlySplitted() {
        String path = "01234";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "4" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenMaxLengthBitStreamIdentifierWhenIntermediatePathIsComputedThenIsSplittedAllAsSubfolder() {
        String path = "012345";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierWhenIntermediatePathIsComputedThenNotEndingDoubleSlash() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("3");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("4");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("56789");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
    }

    @Test
    public void givenBitStreamIdentidierWhenIntermediatePathIsComputedThenMustBeSplitted() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("3");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("4");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("56789");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
    }

    @Test
    public void givenBitStreamIdentifierWithSlashesWhenSanitizedThenSlashesMustBeRemoved() {
        String sInternalId = "01" + File.separator + "22" + File.separator + "33" + File.separator + "4455";
        String computedPath = this.s3BitStoreService.sanitizeIdentifier(sInternalId);
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)File.separator)));
    }

    @Test
    public void givenBitStreamWhenRemoveThenCallS3DeleteMethod() throws Exception {
        String bucketName = "BucketTest";
        String bitStreamId = "BitStreamId";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        this.s3BitStoreService.init();
        this.s3BitStoreService.remove(this.bitstream);
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service, (VerificationMode)Mockito.times((int)1))).deleteObject((String)ArgumentMatchers.eq((Object)bucketName), (String)ArgumentMatchers.eq((Object)bitStreamId));
    }

    @Test
    public void givenBitStreamWhenPutThenCallS3PutMethodAndStoresInBitStream() throws Exception {
        String bucketName = "BucketTest";
        String bitStreamId = "BitStreamId";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        File file = (File)Mockito.mock(File.class);
        InputStream in = (InputStream)Mockito.mock(InputStream.class);
        PutObjectResult putObjectResult = (PutObjectResult)Mockito.mock(PutObjectResult.class);
        Upload upload = (Upload)Mockito.mock(Upload.class);
        UploadResult uploadResult = (UploadResult)Mockito.mock(UploadResult.class);
        Mockito.when((Object)upload.waitForUploadResult()).thenReturn((Object)uploadResult);
        String mockedTag = "1a7771d5fdd7bfdfc84033c70b1ba555";
        Mockito.when((Object)file.length()).thenReturn((Object)8L);
        try (MockedStatic fileMock = Mockito.mockStatic(File.class);
             MockedStatic fileUtilsMock = Mockito.mockStatic(FileUtils.class);
             MockedStatic curateUtils = Mockito.mockStatic(Utils.class);){
            curateUtils.when(() -> Utils.checksum((File)((File)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)mockedTag);
            fileMock.when(() -> File.createTempFile((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)file);
            Mockito.when((Object)this.tm.upload((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (File)ArgumentMatchers.any())).thenReturn((Object)upload);
            this.s3BitStoreService.init();
            this.s3BitStoreService.put(this.bitstream, in);
        }
        ((Bitstream)Mockito.verify((Object)this.bitstream, (VerificationMode)Mockito.times((int)1))).setSizeBytes(ArgumentMatchers.eq((long)8L));
        ((Bitstream)Mockito.verify((Object)this.bitstream, (VerificationMode)Mockito.times((int)1))).setChecksum((String)ArgumentMatchers.eq((Object)mockedTag));
        ((TransferManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).upload((String)ArgumentMatchers.eq((Object)bucketName), (String)ArgumentMatchers.eq((Object)bitStreamId), (File)ArgumentMatchers.eq((Object)file));
        ((File)Mockito.verify((Object)file, (VerificationMode)Mockito.times((int)1))).delete();
    }

    @Test
    public void givenBitStreamWhenCallingPutFileCopyingThrowsIOExceptionPutThenFileIsRemovedAndStreamClosed() throws Exception {
        String bucketName = "BucketTest";
        String bitStreamId = "BitStreamId";
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.setUseRelativePath(false);
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        File file = (File)Mockito.mock(File.class);
        InputStream in = (InputStream)Mockito.mock(InputStream.class);
        try (MockedStatic fileMock = Mockito.mockStatic(File.class);
             MockedStatic fileUtilsMock = Mockito.mockStatic(FileUtils.class);){
            fileUtilsMock.when(() -> FileUtils.copyInputStreamToFile((InputStream)((InputStream)ArgumentMatchers.any()), (File)((File)ArgumentMatchers.any()))).thenThrow(IOException.class);
            fileMock.when(() -> File.createTempFile((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)file);
            this.s3BitStoreService.init();
            Assert.assertThrows(IOException.class, () -> this.s3BitStoreService.put(this.bitstream, in));
        }
        ((Bitstream)Mockito.verify((Object)this.bitstream, (VerificationMode)Mockito.never())).setSizeBytes(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((Bitstream)Mockito.verify((Object)this.bitstream, (VerificationMode)Mockito.never())).setChecksum((String)ArgumentMatchers.any(String.class));
        ((AmazonS3Client)Mockito.verify((Object)this.s3Service, (VerificationMode)Mockito.never())).putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class));
        ((File)Mockito.verify((Object)file, (VerificationMode)Mockito.times((int)1))).delete();
    }

    private int computeSlashes(String internalId) {
        int minimum = internalId.length();
        int slashesPerLevel = minimum / 2;
        int odd = Math.min(1, minimum % 2);
        int slashes = slashesPerLevel + odd;
        return Math.min(slashes, 3);
    }
}

