/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.alerts;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.alerts.SystemWideAlert;
import org.dspace.alerts.SystemWideAlertServiceImpl;
import org.dspace.alerts.dao.SystemWideAlertDAO;
import org.dspace.alerts.service.SystemWideAlertService;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SystemWideAlertServiceTest {
    private static final Logger log = LogManager.getLogger(SystemWideAlertService.class);
    @InjectMocks
    private SystemWideAlertServiceImpl systemWideAlertService;
    @Mock
    private SystemWideAlertDAO systemWideAlertDAO;
    @Mock
    private AuthorizeService authorizeService;
    @Mock
    private Context context;
    @Mock
    private SystemWideAlert systemWideAlert;
    @Mock
    private EPerson eperson;

    @Test
    public void testCreate() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        SystemWideAlert systemWideAlert = new SystemWideAlert();
        systemWideAlert.setMessage("Test message");
        systemWideAlert.setAllowSessions(AllowSessionsEnum.ALLOW_ALL_SESSIONS);
        systemWideAlert.setCountdownTo(null);
        systemWideAlert.setActive(true);
        Mockito.when((Object)((SystemWideAlert)this.systemWideAlertDAO.create((Context)ArgumentMatchers.any(), (Object)((SystemWideAlert)ArgumentMatchers.any())))).thenReturn((Object)systemWideAlert);
        SystemWideAlert result = this.systemWideAlertService.create(this.context, "Test message", AllowSessionsEnum.ALLOW_ALL_SESSIONS, null, true);
        Assert.assertEquals((String)"TestCreate 0", (Object)systemWideAlert.getMessage(), (Object)result.getMessage());
        Assert.assertEquals((String)"TestCreate 1", (Object)systemWideAlert, (Object)result);
    }

    @Test
    public void testFindAll() throws Exception {
        ArrayList systemWideAlertList = new ArrayList();
        Assert.assertEquals((String)"TestFindAll 0", systemWideAlertList, (Object)this.systemWideAlertService.findAll(this.context));
    }

    @Test
    public void testFind() throws Exception {
        Mockito.when((Object)this.systemWideAlertService.find(this.context, 0)).thenReturn((Object)this.systemWideAlert);
        Assert.assertEquals((String)"TestFind 0", (Object)this.systemWideAlert, (Object)this.systemWideAlertService.find(this.context, 0));
    }

    @Test
    public void testFindAllActive() throws Exception {
        ArrayList systemWideAlertList = new ArrayList();
        Assert.assertEquals((String)"TestFindAllActive 0", systemWideAlertList, (Object)this.systemWideAlertService.findAllActive(this.context, 10, 0));
    }

    @Test
    public void testUpdate() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        this.systemWideAlertService.update(this.context, this.systemWideAlert);
        ((SystemWideAlertDAO)Mockito.verify((Object)this.systemWideAlertDAO, (VerificationMode)Mockito.times((int)1))).save(this.context, (Object)this.systemWideAlert);
    }

    @Test
    public void testDelete() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        this.systemWideAlertService.delete(this.context, this.systemWideAlert);
        ((SystemWideAlertDAO)Mockito.verify((Object)this.systemWideAlertDAO, (VerificationMode)Mockito.times((int)1))).delete(this.context, (Object)this.systemWideAlert);
    }

    @Test
    public void canNonAdminUserLoginTrueTest() throws Exception {
        Mockito.when((Object)this.systemWideAlert.getAllowSessions()).thenReturn((Object)AllowSessionsEnum.ALLOW_ALL_SESSIONS);
        ArrayList<SystemWideAlert> systemWideAlertList = new ArrayList<SystemWideAlert>();
        systemWideAlertList.add(this.systemWideAlert);
        Mockito.when((Object)this.systemWideAlertDAO.findAllActive(this.context, 1, 0)).thenReturn(systemWideAlertList);
        Assert.assertTrue((String)"CanNonAdminUserLogin 0", (boolean)this.systemWideAlertService.canNonAdminUserLogin(this.context));
    }

    @Test
    public void canNonAdminUserLoginFalseTest() throws Exception {
        Mockito.when((Object)this.systemWideAlert.getAllowSessions()).thenReturn((Object)AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY);
        ArrayList<SystemWideAlert> systemWideAlertList = new ArrayList<SystemWideAlert>();
        systemWideAlertList.add(this.systemWideAlert);
        Mockito.when((Object)this.systemWideAlertDAO.findAllActive(this.context, 1, 0)).thenReturn(systemWideAlertList);
        Assert.assertFalse((String)"CanNonAdminUserLogin 1", (boolean)this.systemWideAlertService.canNonAdminUserLogin(this.context));
    }

    @Test
    public void canUserMaintainSessionAdminTest() throws Exception {
        Assert.assertTrue((String)"CanUserMaintainSession 0", (boolean)this.systemWideAlertService.canNonAdminUserLogin(this.context));
    }

    @Test
    public void canUserMaintainSessionTrueTest() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context, this.eperson)).thenReturn((Object)false);
        Mockito.when((Object)this.systemWideAlert.getAllowSessions()).thenReturn((Object)AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY);
        ArrayList<SystemWideAlert> systemWideAlertList = new ArrayList<SystemWideAlert>();
        systemWideAlertList.add(this.systemWideAlert);
        Mockito.when((Object)this.systemWideAlertDAO.findAllActive(this.context, 1, 0)).thenReturn(systemWideAlertList);
        Assert.assertTrue((String)"CanUserMaintainSession 1", (boolean)this.systemWideAlertService.canUserMaintainSession(this.context, this.eperson));
    }

    @Test
    public void canUserMaintainSessionFalseTest() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context, this.eperson)).thenReturn((Object)false);
        Mockito.when((Object)this.systemWideAlert.getAllowSessions()).thenReturn((Object)AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY);
        ArrayList<SystemWideAlert> systemWideAlertList = new ArrayList<SystemWideAlert>();
        systemWideAlertList.add(this.systemWideAlert);
        Mockito.when((Object)this.systemWideAlertDAO.findAllActive(this.context, 1, 0)).thenReturn(systemWideAlertList);
        Assert.assertFalse((String)"CanUserMaintainSession 2", (boolean)this.systemWideAlertService.canUserMaintainSession(this.context, this.eperson));
    }
}

