/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import junit.framework.TestCase;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.junit.Before;
import org.junit.Test;

public class CSVMetadataImportReferenceIT
extends AbstractIntegrationTestWithDatabase {
    private Collection col;
    private Collection col1;
    private Collection col2;
    private final RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    Community parentCommunity;

    @Before
    public void setup() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.col = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
        this.col1 = CollectionBuilder.createCollection(this.context, this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        this.col2 = CollectionBuilder.createCollection(this.context, this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Project").build();
        EntityTypeBuilder.createEntityTypeBuilder(this.context, "OrgUnit").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publication, person, "isAuthorOfPublication", "isPublicationOfAuthor", 0, null, 0, null).withCopyToLeft(false).withCopyToRight(true).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publication, project, "isProjectOfPublication", "isPublicationOfProject", 0, null, 0, null).withCopyToRight(true).build();
        this.context.restoreAuthSystemState();
    }

    private void assertRelationship(Item leftItem, Item rightItem, int expectedCount, String placeDirection, int placeCount) throws SQLException {
        List rels = this.relationshipService.findByItem(this.context, rightItem);
        Relationship relationship = null;
        int foundCount = 0;
        for (Relationship rel : rels) {
            if (!rel.getRightItem().getID().equals(rightItem.getID()) || !rel.getLeftItem().getID().equals(leftItem.getID())) continue;
            ++foundCount;
            relationship = rel;
        }
        if (placeDirection.equalsIgnoreCase("left")) {
            TestCase.assertEquals((int)relationship.getLeftPlace(), (int)placeCount);
        } else {
            TestCase.assertEquals((int)relationship.getRightPlace(), (int)placeCount);
        }
        TestCase.assertEquals((int)expectedCount, (int)foundCount);
    }

    @Test
    public void testSingleMdRef() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col1.getHandle() + ",0", "+,Publication,dc.identifier.other:0," + this.col2.getHandle() + ",1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], items[0], 1, "left", 0);
        this.cleanupImportItems(items);
    }

    @Test
    public void testSingleMdRefIntoCollectionWithoutEntityTypeTest() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col.getHandle() + ",0", "+,Publication,dc.identifier.other:0," + this.col.getHandle() + ",1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], items[0], 1, "left", 0);
        this.cleanupImportItems(items);
    }

    private Item[] runImport(String[] csvLines) throws Exception {
        this.performImportScript(csvLines, false);
        Item[] items = new Item[csvLines.length - 1];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (Item)this.itemService.findByIdOrLegacyId(this.context, this.getUUIDByIdentifierOther("" + i).toString());
        }
        return items;
    }

    private void cleanupImportItems(Item[] items) throws SQLException, IOException {
        this.context.turnOffAuthorisationSystem();
        for (Item item : items) {
            ItemBuilder.deleteItem(item.getID());
        }
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testSingleRowNameRef() throws Exception {
        String[] csv = new String[]{"id,dc.title,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Test Item 1,Person,," + this.col1.getHandle() + ",idVal,0", "+,Test Item 2,Publication,rowName:idVal," + this.col2.getHandle() + ",anything,1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], items[0], 1, "left", 0);
        this.cleanupImportItems(items);
    }

    @Test
    public void testMultiMdRef() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col1.getHandle() + ",0", "+,Person,," + this.col1.getHandle() + ",1", "+,Publication,dc.identifier.other:0||dc.identifier.other:1," + this.col2.getHandle() + ",2"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[2], items[0], 1, "left", 0);
        this.assertRelationship(items[2], items[1], 1, "left", 1);
        this.cleanupImportItems(items);
    }

    @Test
    public void testMultiRowNameRef() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other,rowName", "+,Person,," + this.col1.getHandle() + ",0,val1", "+,Person,," + this.col1.getHandle() + ",1,val2", "+,Publication,rowName:val1||rowName:val2," + this.col2.getHandle() + ",2,val3"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[2], items[0], 1, "left", 0);
        this.assertRelationship(items[2], items[1], 1, "left", 1);
        this.cleanupImportItems(items);
    }

    @Test
    public void testSingleUUIDReference() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem(this.context, this.col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Publication," + person.getID().toString() + "," + this.col2.getHandle() + ",anything,0"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[0], person, 1, "left", 0);
        this.cleanupImportItems(items);
    }

    @Test
    public void testMultiUUIDReference() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem(this.context, this.col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        Item person2 = ItemBuilder.createItem(this.context, this.col1).withTitle("Author2").withIssueDate("2017-10-17").withAuthor("Smith, John").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("John").build();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Publication," + person.getID().toString() + "||" + person2.getID().toString() + "," + this.col2.getHandle() + ",anything,0"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[0], person, 1, "left", 0);
        this.assertRelationship(items[0], person2, 1, "left", 1);
        this.cleanupImportItems(items);
    }

    @Test
    public void testMultiRefArchivedCsv() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        String[] csv = new String[]{"id,dc.title,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Person2,Person,," + this.col1.getHandle() + ",idVal,0", "+,Pub1,Publication,dc.title:Person||dc.title:Person2," + this.col2.getHandle() + ",anything,1"};
        this.context.restoreAuthSystemState();
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], person, 1, "left", 0);
        this.assertRelationship(items[1], items[0], 1, "left", 1);
        this.cleanupImportItems(items);
    }

    @Test
    public void testMultiMixedRefArchivedCsv() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        Item person2 = ItemBuilder.createItem(this.context, this.col1).withTitle("Person2").withIssueDate("2017-10-17").withAuthor("Smith, John").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("John").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dc.title,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Person3,Person,," + this.col1.getHandle() + ",idVal,0", "+,Pub1,Publication," + person.getID() + "||dc.title:Person2||rowName:idVal," + this.col2.getHandle() + ",anything,1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], person, 1, "left", 0);
        this.assertRelationship(items[1], person2, 1, "left", 1);
        this.assertRelationship(items[1], items[0], 1, "left", 2);
        this.cleanupImportItems(items);
    }

    @Test
    public void testRefWithSpecialChar() throws Exception {
        String[] csv = new String[]{"id,dc.title,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName,dc.identifier.other", "+,Person:,Person,," + this.col1.getHandle() + ",idVal,0", "+,Pub1,Publication,dc.title:Person:," + this.col2.getHandle() + ",anything,1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], items[0], 1, "left", 0);
        this.cleanupImportItems(items);
    }

    @Test(expected=MetadataImportException.class)
    public void testNonUniqueMDRefInCsv() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col1.getHandle() + ",1", "+,Person,," + this.col1.getHandle() + ",1", "+,Publication,dc.identifier.other:1," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, true);
    }

    @Test(expected=MetadataImportException.class)
    public void testNonUniqueRowName() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other,rowName", "+,Person,," + this.col1.getHandle() + ",1,value", "+,Person,," + this.col1.getHandle() + ",1,value", "+,Publication,rowName:value," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, true);
    }

    @Test(expected=MetadataImportException.class)
    public void testNonUniqueMDRefInDb() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withIdentifierOther("1").build();
        ItemBuilder.createItem(this.context, this.col1).withTitle("Person2").withIssueDate("2017-10-17").withAuthor("Smith, John").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("John").withIdentifierOther("1").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Publication,dc.identifier.other:1," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, true);
    }

    @Test(expected=MetadataImportException.class)
    public void testNonUniqueMDRefInBoth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withIdentifierOther("1").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col1.getHandle() + ",1", "+,Publication,dc.identifier.other:1," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, true);
    }

    @Test(expected=Exception.class)
    public void testNonExistMdRef() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Person,," + this.col1.getHandle() + ",1", "+,Publication,dc.identifier.other:8675309," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, false);
    }

    @Test(expected=Exception.class)
    public void testCSVImportWrongOrder() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other", "+,Publication,dc.identifier.other:8675309," + this.col1.getHandle() + ",2", "+,Person,," + this.col1.getHandle() + ",8675309"};
        this.performImportScript(csv, false);
    }

    @Test(expected=Exception.class)
    public void testCSVImportWrongOrderRowName() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other,rowName", "+,Publication,rowName:row2," + this.col1.getHandle() + ",2,row1", "+,Person,," + this.col1.getHandle() + ",8675309,row2"};
        this.performImportScript(csv, false);
    }

    @Test(expected=MetadataImportException.class)
    public void testCSVImportInvalidRelationship() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName", "+,Publication,," + this.col1.getHandle() + ",row1", "+,Unit,rowName:row1," + this.col1.getHandle() + ",row2"};
        this.performImportScript(csv, true);
    }

    @Test(expected=MetadataImportInvalidHeadingException.class)
    public void testInvalidRelationshipArchivedOrigin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection orgUnitCollection = CollectionBuilder.createCollection(this.context, rootCommunity).withEntityType("OrgUnit").withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem(this.context, orgUnitCollection).withTitle("OrgUnit").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName", "+,Person,," + this.col1.getHandle() + ",1" + testItem.getID().toString() + ",,rowName:1," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, false);
    }

    @Test(expected=MetadataImportInvalidHeadingException.class)
    public void testInvalidRelationshipArchivedTarget() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection orgUnitCollection = CollectionBuilder.createCollection(this.context, rootCommunity).withEntityType("OrgUnit").withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem(this.context, orgUnitCollection).withTitle("OrgUnit").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,rowName", testItem.getID().toString() + ",Person,," + this.col1.getHandle() + ",1+,OrgUnit,rowName:1," + this.col1.getHandle() + ",2"};
        this.performImportScript(csv, false);
    }

    @Test
    public void testValidRelationshipNoDefinedTypesInCSV() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection publicationCollection = CollectionBuilder.createCollection(this.context, rootCommunity).withEntityType("Publication").withName("Collection 1").build();
        Collection projectCollection = CollectionBuilder.createCollection(this.context, rootCommunity).withEntityType("Project").withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withIdentifierOther("testItemOne").build();
        Item testItem2 = ItemBuilder.createItem(this.context, publicationCollection).withTitle("Publication").withIssueDate("2017-10-17").withIdentifierOther("testItemTwo").build();
        Item testItem3 = ItemBuilder.createItem(this.context, projectCollection).withTitle("Project").withIssueDate("2017-10-17").withIdentifierOther("testItemThree").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,relation.isAuthorOfPublication,relation.isPublicationOfProject,collection", testItem.getID().toString() + ",,," + this.col1.getHandle(), testItem2.getID().toString() + ",dc.identifier.other:testItemOne,," + this.col1.getHandle(), testItem3.getID().toString() + ",,dc.identifier.other:testItemTwo," + this.col1.getHandle()};
        this.performImportScript(csv, false);
        this.assertRelationship(testItem2, testItem, 1, "left", 0);
        this.assertRelationship(testItem2, testItem3, 1, "left", 0);
    }

    @Test
    public void testDuplicateRowNameReferences() throws Exception {
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other,rowName", "+,Person,," + this.col1.getHandle() + ",0,value", "+,Publication,rowName:value," + this.col2.getHandle() + ",1,1", "+,Publication,rowName:value," + this.col2.getHandle() + ",2,2"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[1], items[0], 1, "left", 0);
        this.assertRelationship(items[2], items[0], 1, "left", 0);
        this.cleanupImportItems(items);
    }

    @Test
    public void testRelationToVirtualDataInReferences() throws Exception {
        Item testItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Person").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withIdentifierOther("testItemOne").build();
        String[] csv = new String[]{"id,dspace.entity.type,relation.isAuthorOfPublication,collection,dc.identifier.other,rowName", "+,Publication," + testItem.getID() + "::virtual::4::600," + this.col2.getHandle() + ",0,1"};
        Item[] items = this.runImport(csv);
        this.assertRelationship(items[0], testItem, 1, "left", 0);
    }

    @Test(expected=MetadataImportException.class)
    public void testInvalidTypeNameDefined() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection publicationCollection = CollectionBuilder.createCollection(this.context, rootCommunity).withEntityType("Publication").withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem(this.context, publicationCollection).withTitle("Publication").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,collection,dspace.entity.type,dc.title,relation.isProjectOfPublication,relation.isPublicationOfProject", "+," + this.col1.getHandle() + ",Project,Title," + testItem.getID().toString() + "," + testItem.getID().toString()};
        this.performImportScript(csv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performImportScript(String[] csv, boolean validateOnly) throws Exception {
        File csvFile = File.createTempFile("dspace-test-import", "csv");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8"));
        for (String csvLine : csv) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
        String fileLocation = csvFile.getAbsolutePath();
        try {
            String[] args = null;
            args = validateOnly ? new String[]{"metadata-import", "-f", fileLocation, "-e", this.eperson.getEmail(), "-s", "-v"} : new String[]{"metadata-import", "-f", fileLocation, "-e", this.eperson.getEmail(), "-s"};
            TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
            ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
            ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
            DSpaceRunnable script = null;
            if (scriptConfiguration != null) {
                script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
            }
            if (script != null && DSpaceRunnable.StepResult.Continue.equals((Object)script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null))) {
                script.run();
            }
            if (testDSpaceRunnableHandler.getException() != null) {
                throw testDSpaceRunnableHandler.getException();
            }
        }
        finally {
            csvFile.delete();
        }
        return 0;
    }

    private UUID getUUIDByIdentifierOther(String value) throws Exception {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
        MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
        MetadataField mfo = metadataFieldService.findByElement(this.context, "dc", "identifier", "other");
        Iterator mdv = metadataValueService.findByFieldAndValue(this.context, mfo, value);
        while (mdv.hasNext()) {
            MetadataValue mdvVal = (MetadataValue)mdv.next();
            uuidList.add(mdvVal.getDSpaceObject().getID());
        }
        return (UUID)uuidList.get(0);
    }
}

