/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.ArrayList;
import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SubmissionConfigTest
extends AbstractUnitTest {
    DCInputsReader inputReader;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() throws DCInputsReaderException {
        this.inputReader = new DCInputsReader();
    }

    @After
    public void tearDown() {
        this.inputReader = null;
    }

    @Test
    public void testReadAndProcessTypeBindSubmissionConfig() throws SubmissionConfigReaderException, DCInputsReaderException {
        String typeBindHandle = "123456789/typebind-test";
        String typeBindSubmissionName = "typebindtest";
        String typeBindSubmissionStepName = "typebindtest";
        ArrayList<String> allConfiguredFields = new ArrayList<String>();
        allConfiguredFields.add("dc.title");
        allConfiguredFields.add("dc.date.issued");
        allConfiguredFields.add("dc.type");
        allConfiguredFields.add("dc.identifier.isbn");
        List unboundFields = allConfiguredFields.subList(0, 3);
        SubmissionConfig submissionConfig = SubmissionServiceFactory.getInstance().getSubmissionConfigService().getSubmissionConfigByCollection(typeBindHandle);
        Assert.assertEquals((Object)typeBindSubmissionName, (Object)submissionConfig.getSubmissionName());
        SubmissionStepConfig submissionStepConfig = submissionConfig.getStep(0);
        Assert.assertNotNull((Object)submissionStepConfig);
        Assert.assertEquals((Object)typeBindSubmissionStepName, (Object)submissionStepConfig.getId());
        DCInputSet inputConfig = this.inputReader.getInputsByFormName(submissionStepConfig.getId());
        List allowedFieldsForBook = inputConfig.populateAllowedFieldNames("Book");
        List allowedFieldsForBookChapter = inputConfig.populateAllowedFieldNames("Book chapter");
        List allowedFieldsForArticle = inputConfig.populateAllowedFieldNames("Article");
        List allowedFieldsForNoType = inputConfig.populateAllowedFieldNames(null);
        Assert.assertEquals(allConfiguredFields, (Object)allowedFieldsForBook);
        Assert.assertEquals(allConfiguredFields, (Object)allowedFieldsForBookChapter);
        Assert.assertEquals(unboundFields, (Object)allowedFieldsForArticle);
        Assert.assertEquals(unboundFields, (Object)allowedFieldsForNoType);
    }
}

