/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractCRUDBuilder;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.service.DSpaceCRUDService;

public class BitstreamFormatBuilder
extends AbstractCRUDBuilder<BitstreamFormat> {
    private static final Logger log = LogManager.getLogger(BitstreamFormatBuilder.class);
    private BitstreamFormat bitstreamFormat;

    protected BitstreamFormatBuilder(Context context) {
        super(context);
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.bitstreamFormat = (BitstreamFormat)c.reloadEntity((ReloadableEntity)this.bitstreamFormat);
            if (this.bitstreamFormat != null) {
                this.delete(c, this.bitstreamFormat);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, BitstreamFormat dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (Object)dso);
        }
    }

    @Override
    protected DSpaceCRUDService<BitstreamFormat> getService() {
        return bitstreamFormatService;
    }

    @Override
    public BitstreamFormat build() {
        try {
            bitstreamFormatService.update(this.context, (Object)this.bitstreamFormat);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SearchServiceException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        catch (AuthorizeException e) {
            log.error((Object)e);
        }
        return this.bitstreamFormat;
    }

    public static BitstreamFormatBuilder createBitstreamFormat(Context context) throws SQLException, AuthorizeException {
        BitstreamFormatBuilder bitstreamFormatBuilder = new BitstreamFormatBuilder(context);
        return bitstreamFormatBuilder.create(context);
    }

    private BitstreamFormatBuilder create(Context context) throws SQLException, AuthorizeException {
        this.context = context;
        this.bitstreamFormat = (BitstreamFormat)bitstreamFormatService.create(context);
        return this;
    }

    public BitstreamFormatBuilder withMimeType(String mimeType) {
        this.bitstreamFormat.setMIMEType(mimeType);
        return this;
    }

    public BitstreamFormatBuilder withDescription(String description) {
        this.bitstreamFormat.setDescription(description);
        return this;
    }

    public BitstreamFormatBuilder withShortDescription(String description) throws SQLException {
        this.bitstreamFormat.setShortDescription(this.context, description);
        return this;
    }

    public BitstreamFormatBuilder withSupportLevel(int supportLevel) throws SQLException {
        this.bitstreamFormat.setSupportLevel(supportLevel);
        return this;
    }

    public static void deleteBitstreamFormat(int id) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            BitstreamFormat bitstreamFormat = (BitstreamFormat)bitstreamFormatService.find(c, id);
            if (bitstreamFormat != null) {
                try {
                    bitstreamFormatService.delete(c, (Object)bitstreamFormat);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
    }
}

