/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipServiceImpl;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.utils.RelationshipVersioningUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationshipServiceImplTest {
    @InjectMocks
    private RelationshipServiceImpl relationshipService;
    @Mock
    private RelationshipDAO relationshipDAO;
    @Mock
    private Context context;
    @Mock
    private Relationship relationship;
    @Mock
    private List<Relationship> relationshipsList;
    @Mock
    private AuthorizeService authorizeService;
    @Mock
    private ItemService itemService;
    @Mock
    private VirtualMetadataPopulator virtualMetadataPopulator;
    @Mock
    private RelationshipTypeService relationshipTypeService;
    @Mock
    private RelationshipMetadataService relationshipMetadataService;
    @Mock
    private EntityTypeService entityTypeService;
    @Mock
    private ConfigurationService configurationService;
    @Spy
    private RelationshipVersioningUtils relationshipVersioningUtils;

    @Before
    public void init() {
        this.relationshipsList = new ArrayList<Relationship>();
        this.relationshipsList.add(this.relationship);
    }

    @Test
    public void testFindAll() throws Exception {
        Mockito.when((Object)this.relationshipDAO.findAll(this.context, Relationship.class, Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(this.relationshipsList);
        Assert.assertEquals((String)"TestFindAll 0", this.relationshipsList, (Object)this.relationshipService.findAll(this.context));
    }

    @Test
    public void testFindByItem() throws Exception {
        ArrayList<Relationship> relationshipTest = new ArrayList<Relationship>();
        Item cindy = (Item)Mockito.mock(Item.class);
        Item fred = (Item)Mockito.mock(Item.class);
        Item bob = (Item)Mockito.mock(Item.class);
        Item hank = (Item)Mockito.mock(Item.class);
        Item jasper = (Item)Mockito.mock(Item.class);
        Item spot = (Item)Mockito.mock(Item.class);
        RelationshipType hasDog = new RelationshipType();
        RelationshipType hasFather = new RelationshipType();
        RelationshipType hasMother = new RelationshipType();
        hasDog.setLeftwardType("hasDog");
        hasDog.setRightwardType("isDogOf");
        hasFather.setLeftwardType("hasFather");
        hasFather.setRightwardType("isFatherOf");
        hasMother.setLeftwardType("hasMother");
        hasMother.setRightwardType("isMotherOf");
        relationshipTest.add(this.getRelationship(cindy, spot, hasDog, 0, 0));
        relationshipTest.add(this.getRelationship(cindy, jasper, hasDog, 0, 1));
        relationshipTest.add(this.getRelationship(cindy, hank, hasFather, 0, 0));
        relationshipTest.add(this.getRelationship(fred, cindy, hasMother, 0, 0));
        relationshipTest.add(this.getRelationship(bob, cindy, hasMother, 1, 0));
        Mockito.when((Object)this.relationshipService.findByItem(this.context, cindy, Integer.valueOf(-1), Integer.valueOf(-1), false)).thenReturn(relationshipTest);
        List results = this.relationshipService.findByItem(this.context, cindy);
        Assert.assertEquals((String)"TestFindByItem 0", relationshipTest, (Object)results);
        for (int i = 0; i < relationshipTest.size(); ++i) {
            Assert.assertEquals((String)"TestFindByItem sort integrity", relationshipTest.get(i), results.get(i));
        }
    }

    @Test
    public void testFindByItemAndRelationshipType() throws Exception {
        ArrayList relList = new ArrayList();
        Item item = (Item)Mockito.mock(Item.class);
        RelationshipType testRel = new RelationshipType();
        Assert.assertEquals((String)"TestFindByItemAndRelationshipType 0", relList, (Object)this.relationshipService.findByItemAndRelationshipType(this.context, item, testRel, true));
        Assert.assertEquals((String)"TestFindByItemAndRelationshipType 1", relList, (Object)this.relationshipService.findByItemAndRelationshipType(this.context, item, testRel));
    }

    @Test
    public void testFindByRelationshipType() throws Exception {
        ArrayList relList = new ArrayList();
        RelationshipType testRel = new RelationshipType();
        Assert.assertEquals((String)"TestFindByRelationshipType 0", relList, (Object)this.relationshipService.findByRelationshipType(this.context, testRel));
    }

    @Test
    public void find() throws Exception {
        Relationship relationship = new Relationship();
        relationship.setId(Integer.valueOf(1337));
        Mockito.when((Object)((Relationship)this.relationshipDAO.findByID(this.context, Relationship.class, relationship.getID().intValue()))).thenReturn((Object)relationship);
        Assert.assertEquals((String)"TestFind 0", (Object)relationship, (Object)this.relationshipService.find(this.context, relationship.getID().intValue()));
    }

    @Test
    public void testCreate() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        Relationship relationship = (Relationship)this.relationshipDAO.create(this.context, (Object)new Relationship());
        this.context.turnOffAuthorisationSystem();
        Assert.assertEquals((String)"TestCreate 0", (Object)relationship, (Object)this.relationshipService.create(this.context));
        MetadataValue metVal = (MetadataValue)Mockito.mock(MetadataValue.class);
        ArrayList<MetadataValue> metsList = new ArrayList<MetadataValue>();
        ArrayList<Relationship> leftTypelist = new ArrayList<Relationship>();
        ArrayList<Relationship> rightTypelist = new ArrayList<Relationship>();
        Item leftItem = (Item)Mockito.mock(Item.class);
        Item rightItem = (Item)Mockito.mock(Item.class);
        RelationshipType testRel = new RelationshipType();
        EntityType leftEntityType = (EntityType)Mockito.mock(EntityType.class);
        EntityType rightEntityType = (EntityType)Mockito.mock(EntityType.class);
        testRel.setLeftType(leftEntityType);
        testRel.setRightType(rightEntityType);
        testRel.setLeftwardType("Entitylabel");
        testRel.setRightwardType("Entitylabel");
        metsList.add(metVal);
        relationship = this.getRelationship(leftItem, rightItem, testRel, 0, 0);
        leftTypelist.add(relationship);
        rightTypelist.add(relationship);
        Mockito.when((Object)this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), true)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)relationship.getLeftItem(), 1)).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipService.findByItem(this.context, leftItem)).thenReturn(leftTypelist);
        Mockito.when((Object)this.relationshipService.findByItem(this.context, rightItem)).thenReturn(rightTypelist);
        Mockito.when((Object)leftEntityType.getLabel()).thenReturn((Object)"Entitylabel");
        Mockito.when((Object)rightEntityType.getLabel()).thenReturn((Object)"Entitylabel");
        Mockito.when((Object)metVal.getValue()).thenReturn((Object)"Entitylabel");
        Mockito.when((Object)((MetadataValue)metsList.get(0)).getValue()).thenReturn((Object)"Entitylabel");
        Mockito.when((Object)this.relationshipService.findByItemAndRelationshipType(this.context, leftItem, testRel, true)).thenReturn(leftTypelist);
        Mockito.when((Object)this.itemService.getMetadata(leftItem, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)this.itemService.getMetadata(rightItem, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)((Relationship)this.relationshipDAO.create((Context)ArgumentMatchers.any(), (Object)((Relationship)ArgumentMatchers.any())))).thenReturn((Object)relationship);
        Assert.assertEquals((String)"TestCreate 1", (Object)relationship, (Object)this.relationshipService.create(this.context, relationship));
        Assert.assertEquals((String)"TestCreate 2", (Object)relationship, (Object)this.relationshipService.create(this.context, leftItem, rightItem, testRel, 0, 0));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testDelete() throws Exception {
        ArrayList<Relationship> leftTypelist = new ArrayList<Relationship>();
        ArrayList<Relationship> rightTypelist = new ArrayList<Relationship>();
        Item leftItem = (Item)Mockito.mock(Item.class);
        Item rightItem = (Item)Mockito.mock(Item.class);
        RelationshipType testRel = new RelationshipType();
        EntityType leftEntityType = (EntityType)Mockito.mock(EntityType.class);
        EntityType rightEntityType = (EntityType)Mockito.mock(EntityType.class);
        testRel.setLeftType(leftEntityType);
        testRel.setRightType(rightEntityType);
        testRel.setLeftwardType("Entitylabel");
        testRel.setRightwardType("Entitylabel");
        testRel.setLeftMinCardinality(Integer.valueOf(0));
        testRel.setRightMinCardinality(Integer.valueOf(0));
        this.relationship = this.getRelationship(leftItem, rightItem, testRel, 0, 0);
        leftTypelist.add(this.relationship);
        rightTypelist.add(this.relationship);
        Mockito.when((Object)this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(this.relationship.getRelationshipType(), true)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)this.relationship.getLeftItem(), 1)).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipService.findByItem(this.context, leftItem)).thenReturn(leftTypelist);
        Mockito.when((Object)this.relationshipService.findByItem(this.context, rightItem)).thenReturn(rightTypelist);
        Mockito.when((Object)this.relationshipService.findByItemAndRelationshipType(this.context, leftItem, testRel, true)).thenReturn(leftTypelist);
        Mockito.when((Object)this.relationshipService.findByItemAndRelationshipType(this.context, rightItem, testRel, false)).thenReturn(rightTypelist);
        Mockito.when((Object)this.relationshipService.find(this.context, 0)).thenReturn((Object)this.relationship);
        this.relationshipService.delete(this.context, this.relationship);
        ((RelationshipDAO)Mockito.verify((Object)this.relationshipDAO)).delete(this.context, (Object)this.relationship);
    }

    @Test
    public void testUpdate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataValue metVal = (MetadataValue)Mockito.mock(MetadataValue.class);
        ArrayList<MetadataValue> metsList = new ArrayList<MetadataValue>();
        Item leftItem = (Item)Mockito.mock(Item.class);
        Item rightItem = (Item)Mockito.mock(Item.class);
        RelationshipType testRel = new RelationshipType();
        EntityType leftEntityType = (EntityType)Mockito.mock(EntityType.class);
        EntityType rightEntityType = (EntityType)Mockito.mock(EntityType.class);
        testRel.setLeftType(leftEntityType);
        testRel.setRightType(rightEntityType);
        testRel.setLeftwardType("Entitylabel");
        testRel.setRightwardType("Entitylabel");
        testRel.setLeftMinCardinality(Integer.valueOf(0));
        testRel.setRightMinCardinality(Integer.valueOf(0));
        metsList.add(metVal);
        this.relationship = this.getRelationship(leftItem, rightItem, testRel, 0, 0);
        Mockito.when((Object)this.itemService.getMetadata(leftItem, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)this.itemService.getMetadata(rightItem, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)this.relationship.getLeftItem(), 1)).thenReturn((Object)true);
        this.relationshipService.update(this.context, this.relationship);
        ((RelationshipDAO)Mockito.verify((Object)this.relationshipDAO)).save(this.context, (Object)this.relationship);
    }

    @Test
    public void testCountTotal() throws Exception {
        Mockito.when((Object)this.relationshipDAO.countRows(this.context)).thenReturn((Object)0);
        Assert.assertEquals((String)"TestCountTotal 1", (long)0L, (long)this.relationshipService.countTotal(this.context));
    }

    private Relationship getRelationship(Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace) {
        Relationship relationship = new Relationship();
        relationship.setId(Integer.valueOf(0));
        relationship.setLeftItem(leftItem);
        relationship.setRightItem(rightItem);
        relationship.setRelationshipType(relationshipType);
        relationship.setLeftPlace(leftPlace);
        relationship.setRightPlace(rightPlace);
        return relationship;
    }
}

