/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.RequestItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.versioning.Version;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersioningService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemServiceIT
extends AbstractIntegrationTestWithDatabase {
    private static final Logger log = LogManager.getLogger(ItemServiceIT.class);
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    Community community;
    Collection collection1;
    Item item;
    String authorQualifier = "author";
    String contributorElement = "contributor";
    String dcSchema = "dc";
    String subjectElement = "subject";
    String descriptionElement = "description";
    String abstractQualifier = "abstract";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = CommunityBuilder.createCommunity(this.context).build();
            this.collection1 = CollectionBuilder.createCollection(this.context, this.community).withEntityType("Publication").build();
            WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection1, false);
            this.item = this.installItemService.installItem(this.context, (InProgressSubmission)is);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Test
    public void preserveMetadataOrder() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one", null, 0, 2);
        MetadataValue placeZero = this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two", null, 0, 0);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three", null, 0, 1);
        this.context.commit();
        this.context.restoreAuthSystemState();
        List defaultMetadata = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)defaultMetadata, (Matcher)Matchers.hasSize((int)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 0, (MetadataValue)defaultMetadata.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)defaultMetadata.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)defaultMetadata.get(2));
        List nonVirtualMetadatas = this.itemService.getMetadata(this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*", false);
        MatcherAssert.assertThat((Object)nonVirtualMetadatas, (Matcher)Matchers.hasSize((int)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 0, (MetadataValue)nonVirtualMetadatas.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)nonVirtualMetadatas.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)nonVirtualMetadatas.get(2));
        this.context.turnOffAuthorisationSystem();
        this.item = (Item)this.context.reloadEntity((ReloadableEntity)this.item);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*", "test, latest", null, 0);
        this.itemService.removeMetadataValues(this.context, (DSpaceObject)this.item, List.of(placeZero));
        this.itemService.addAndShiftRightMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*", "test, new", null, 0, 0);
        defaultMetadata = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)defaultMetadata, (Matcher)Matchers.hasSize((int)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, new", null, 0, (MetadataValue)defaultMetadata.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)defaultMetadata.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)defaultMetadata.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, latest", null, 3, (MetadataValue)defaultMetadata.get(3));
        nonVirtualMetadatas = this.itemService.getMetadata(this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*", false);
        MatcherAssert.assertThat((Object)nonVirtualMetadatas, (Matcher)Matchers.hasSize((int)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, new", null, 0, (MetadataValue)nonVirtualMetadatas.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)nonVirtualMetadatas.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)nonVirtualMetadatas.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, latest", null, 3, (MetadataValue)nonVirtualMetadatas.get(3));
        MatcherAssert.assertThat((Object)defaultMetadata.size(), (Matcher)CoreMatchers.equalTo((Object)nonVirtualMetadatas.size()));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(0)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(0))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(1)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(1))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(2)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(2))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(3)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(3))));
        this.context.commit();
        this.context.restoreAuthSystemState();
        this.item = (Item)this.context.reloadEntity((ReloadableEntity)this.item);
        defaultMetadata = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)defaultMetadata, (Matcher)Matchers.hasSize((int)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, new", null, 0, (MetadataValue)defaultMetadata.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)defaultMetadata.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)defaultMetadata.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, latest", null, 3, (MetadataValue)defaultMetadata.get(3));
        nonVirtualMetadatas = this.itemService.getMetadata(this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*", false);
        MatcherAssert.assertThat((Object)nonVirtualMetadatas, (Matcher)Matchers.hasSize((int)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, new", null, 0, (MetadataValue)nonVirtualMetadatas.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 1, (MetadataValue)nonVirtualMetadatas.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 2, (MetadataValue)nonVirtualMetadatas.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, latest", null, 3, (MetadataValue)nonVirtualMetadatas.get(3));
        MatcherAssert.assertThat((Object)defaultMetadata.size(), (Matcher)CoreMatchers.equalTo((Object)nonVirtualMetadatas.size()));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(0)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(0))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(1)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(1))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(2)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(2))));
        MatcherAssert.assertThat((Object)((MetadataValue)defaultMetadata.get(3)), (Matcher)CoreMatchers.equalTo((Object)((MetadataValue)nonVirtualMetadatas.get(3))));
    }

    @Test
    public void InsertAndMoveMetadataShiftPlaceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addAndShiftRightMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four", null, -1, 1);
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
        this.itemService.moveMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, 2, 0);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
    }

    @Test
    public void InsertAndMoveMetadataShiftPlaceTest_complex() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, null, "test, sub1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, null, "test, sub2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, null, "test, abs1");
        this.context.restoreAuthSystemState();
        List list1 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list1.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list1.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list1.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list1.get(2));
        List list2 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list2.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list2.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list2.get(1));
        List list3 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list3.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list3.get(0));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addAndShiftRightMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four", null, -1, 1);
        List list4 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list4.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list4.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 1, (MetadataValue)list4.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 2, (MetadataValue)list4.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list4.get(3));
        List list5 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list5.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list5.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list5.get(1));
        List list6 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list3.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list6.get(0));
        this.itemService.moveMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, 2, 0);
        this.context.restoreAuthSystemState();
        List list7 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list7.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 0, (MetadataValue)list7.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 1, (MetadataValue)list7.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 2, (MetadataValue)list7.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list7.get(3));
        List list8 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list8.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list8.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list8.get(1));
        List list9 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list9.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list9.get(0));
    }

    @Test
    public void InsertAndMoveMetadataOnePlaceForwardTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addAndShiftRightMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four", null, -1, 1);
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
        this.itemService.moveMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, 1, 2);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
    }

    @Test
    public void InsertAndMoveMetadataOnePlaceForwardTest_complex() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, null, "test, abs1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, null, "test, sub1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, null, "test, sub2");
        this.context.restoreAuthSystemState();
        List list1 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list1.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list1.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list1.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list1.get(2));
        List list2 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list2.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list2.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list2.get(1));
        List list3 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list3.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list3.get(0));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addAndShiftRightMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four", null, -1, 1);
        List list4 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list4.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list4.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 1, (MetadataValue)list4.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 2, (MetadataValue)list4.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list4.get(3));
        List list5 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list5.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list5.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list5.get(1));
        List list6 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list6.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list6.get(0));
        this.itemService.moveMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, 1, 2);
        this.context.restoreAuthSystemState();
        List list7 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*").stream().sorted(Comparator.comparingInt(MetadataValue::getPlace)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)list7.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list7.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list7.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 2, (MetadataValue)list7.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list7.get(3));
        List list8 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.subjectElement, null, "*");
        MatcherAssert.assertThat((Object)list8.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub1", null, 0, (MetadataValue)list8.get(0));
        this.assertMetadataValue(null, this.subjectElement, this.dcSchema, "test, sub2", null, 1, (MetadataValue)list8.get(1));
        List list9 = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.descriptionElement, this.abstractQualifier, "*");
        MatcherAssert.assertThat((Object)list9.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.abstractQualifier, this.descriptionElement, this.dcSchema, "test, abs1", null, 0, (MetadataValue)list9.get(0));
    }

    @Test
    public void testDeleteItemWithMultipleVersions() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType personEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publicationEntityType, personEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        Collection collection2 = CollectionBuilder.createCollection(this.context, this.community).withEntityType("Person").build();
        Item publication1 = ItemBuilder.createItem(this.context, this.collection1).withTitle("publication 1").build();
        Item person1 = ItemBuilder.createItem(this.context, collection2).withTitle("person 2").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, publication1, person1, isAuthorOfPublication);
        Version newVersion = this.versioningService.createNewVersion(this.context, publication1);
        Item newPublication1 = newVersion.getItem();
        WorkspaceItem newPublication1WSI = this.workspaceItemService.findByItem(this.context, newPublication1);
        this.installItemService.installItem(this.context, (InProgressSubmission)newPublication1WSI);
        this.context.dispatchEvents();
        List relationships1 = this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true);
        Assert.assertEquals((long)1L, (long)relationships1.size());
        List relationships2 = this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false);
        Assert.assertEquals((long)2L, (long)relationships2.size());
        this.itemService.delete(this.context, (DSpaceObject)person1);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testFindItemsWithEditNoRights() throws Exception {
        this.context.setCurrentUser(this.eperson);
        List result = this.itemService.findItemsWithEdit(this.context, 0, 10);
        int count = this.itemService.countItemsWithEdit(this.context);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testFindAndCountItemsWithEditEPerson() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy(this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.item).withAction(1).build();
        this.context.setCurrentUser(this.eperson);
        List result = this.itemService.findItemsWithEdit(this.context, 0, 10);
        int count = this.itemService.countItemsWithEdit(this.context);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testFindAndCountItemsWithAdminEPerson() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy(this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.item).withAction(11).build();
        this.context.setCurrentUser(this.eperson);
        List result = this.itemService.findItemsWithEdit(this.context, 0, 10);
        int count = this.itemService.countItemsWithEdit(this.context);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testFindAndCountItemsWithEditGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup(this.context).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy(this.context).withGroup(group).withDspaceObject((DSpaceObject)this.item).withAction(1).build();
        this.context.setCurrentUser(this.eperson);
        List result = this.itemService.findItemsWithEdit(this.context, 0, 10);
        int count = this.itemService.countItemsWithEdit(this.context);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testFindAndCountItemsWithAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup(this.context).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy(this.context).withGroup(group).withDspaceObject((DSpaceObject)this.item).withAction(11).build();
        this.context.setCurrentUser(this.eperson);
        List result = this.itemService.findItemsWithEdit(this.context, 0, 10);
        int count = this.itemService.countItemsWithEdit(this.context);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testRemoveItemThatHasRequests() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection1).withTitle("Test").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, (InputStream)is).build();
        RequestItem requestItem = RequestItemBuilder.createRequestItem(this.context, item, bitstream).build();
        this.itemService.delete(this.context, (DSpaceObject)item);
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        Assert.assertNull((Object)this.itemService.find(this.context, item.getID()));
    }

    @Test
    public void testMoveItemToCollectionWithMoreRestrictiveItemReadPolicy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group anonymous = this.groupService.findByName(this.context, "Anonymous");
        Group admin = this.groupService.findByName(this.context, "Administrator");
        Collection permissive = CollectionBuilder.createCollection(this.context, this.community).build();
        Collection restrictive = CollectionBuilder.createCollection(this.context, this.community).build();
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)restrictive, 10);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)restrictive, 10, admin);
        Item item = ItemBuilder.createItem(this.context, permissive).build();
        Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, InputStream.nullInputStream()).build();
        Bundle bundle = (Bundle)item.getBundles("ORIGINAL").get(0);
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bundle, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bitstream, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        this.itemService.move(this.context, item, permissive, restrictive, true);
        Assert.assertEquals(List.of(admin), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(admin), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bundle, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bitstream, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testMoveItemToCollectionWithMoreRestrictiveBitstreamReadPolicy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group anonymous = this.groupService.findByName(this.context, "Anonymous");
        Group admin = this.groupService.findByName(this.context, "Administrator");
        Collection permissive = CollectionBuilder.createCollection(this.context, this.community).build();
        Collection restrictive = CollectionBuilder.createCollection(this.context, this.community).build();
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)restrictive, 9);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)restrictive, 9, admin);
        Item item = ItemBuilder.createItem(this.context, permissive).build();
        Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, InputStream.nullInputStream()).build();
        Bundle bundle = (Bundle)item.getBundles("ORIGINAL").get(0);
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bundle, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bitstream, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        this.itemService.move(this.context, item, permissive, restrictive, true);
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(anonymous), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bundle, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        Assert.assertEquals(List.of(admin), this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bitstream, 0).stream().map(ResourcePolicy::getGroup).collect(Collectors.toList()));
        this.context.restoreAuthSystemState();
    }

    private void assertMetadataValue(String authorQualifier, String contributorElement, String dcSchema, String value, String authority, int place, MetadataValue metadataValue) {
        MatcherAssert.assertThat((Object)metadataValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)dcSchema));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)contributorElement));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)authorQualifier));
        MatcherAssert.assertThat((Object)metadataValue.getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authority));
        MatcherAssert.assertThat((Object)metadataValue.getPlace(), (Matcher)CoreMatchers.equalTo((Object)place));
    }
}

