/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.IdentifierServiceImpl;
import org.dspace.identifier.VersionedHandleIdentifierProvider;
import org.dspace.identifier.VersionedHandleIdentifierProviderWithCanonicalHandles;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionedHandleIdentifierProviderIT
extends AbstractIntegrationTestWithDatabase {
    private ServiceManager serviceManager;
    private IdentifierServiceImpl identifierService;
    private String firstHandle;
    private Collection collection;
    private Item itemV1;
    private Item itemV2;
    private Item itemV3;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        this.identifierService = (IdentifierServiceImpl)this.serviceManager.getServicesByType(IdentifierServiceImpl.class).get(0);
        this.identifierService.setProviders(new ArrayList());
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
    }

    private void registerProvider(Class type) {
        this.serviceManager.registerServiceClass(type.getName(), type);
        IdentifierProvider identifierProvider = (IdentifierProvider)this.serviceManager.getServiceByName(type.getName(), type);
        this.identifierService.setProviders(List.of(identifierProvider));
    }

    private void createVersions() throws SQLException, AuthorizeException {
        this.itemV1 = ItemBuilder.createItem(this.context, this.collection).withTitle("First version").build();
        this.firstHandle = this.itemV1.getHandle();
        this.itemV2 = VersionBuilder.createVersion(this.context, this.itemV1, "Second version").build().getItem();
        this.itemV3 = VersionBuilder.createVersion(this.context, this.itemV1, "Third version").build().getItem();
    }

    @Test
    public void testDefaultVersionedHandleProvider() throws Exception {
        this.registerProvider(VersionedHandleIdentifierProvider.class);
        this.createVersions();
        Assert.assertEquals((Object)this.firstHandle, (Object)this.itemV1.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV1.getHandles().size());
        Assert.assertEquals((Object)(this.firstHandle + ".2"), (Object)this.itemV2.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV2.getHandles().size());
        Assert.assertEquals((Object)(this.firstHandle + ".3"), (Object)this.itemV3.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV3.getHandles().size());
    }

    @Test
    public void testCanonicalVersionedHandleProvider() throws Exception {
        this.registerProvider(VersionedHandleIdentifierProviderWithCanonicalHandles.class);
        this.createVersions();
        Assert.assertEquals((Object)(this.firstHandle + ".1"), (Object)this.itemV1.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV1.getHandles().size());
        Assert.assertEquals((Object)(this.firstHandle + ".2"), (Object)this.itemV2.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV2.getHandles().size());
        Assert.assertEquals((Object)this.firstHandle, (Object)this.itemV3.getHandle());
        Assert.assertEquals((long)2L, (long)this.itemV3.getHandles().size());
        this.containsHandle(this.itemV3, this.firstHandle + ".3");
    }

    private void containsHandle(Item item, String handle) {
        Assert.assertTrue((boolean)item.getHandles().stream().anyMatch(h -> handle.equals(h.getHandle())));
    }
}

