/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.XmlWorkflowFactoryImpl;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlWorkflowFactoryTest
extends AbstractUnitTest {
    private final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final XmlWorkflowFactory xmlWorkflowFactory = (XmlWorkflowFactory)new DSpace().getServiceManager().getServiceByName("xmlWorkflowFactory", XmlWorkflowFactoryImpl.class);
    private Community owningCommunity;
    private Collection mappedCollection;
    private Collection nonMappedCollection;
    private static final Logger log = LogManager.getLogger(XmlWorkflowFactoryTest.class);

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.mappedCollection = this.collectionService.create(this.context, this.owningCommunity, "123456789/workflow-test-1");
            this.nonMappedCollection = this.collectionService.create(this.context, this.owningCommunity, "123456789/999");
            this.context.restoreAuthSystemState();
        }
        catch (SQLException e) {
            log.error("SQL Error in init", (Throwable)e);
            Assert.fail((String)("SQL Error in init: " + e.getMessage()));
        }
        catch (AuthorizeException e) {
            log.error("Authorization Error in init", (Throwable)e);
            Assert.fail((String)("Authorization Error in init: " + e.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.nonMappedCollection);
            this.collectionService.delete(this.context, (DSpaceObject)this.mappedCollection);
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error("Error in destroy", e);
        }
        this.context.restoreAuthSystemState();
        this.owningCommunity = null;
        this.nonMappedCollection = null;
        this.mappedCollection = null;
        try {
            super.destroy();
        }
        catch (Exception e) {
            log.error("Error in destroy", (Throwable)e);
        }
    }

    @Test
    public void workflowMapping_NonMappedCollection() throws WorkflowConfigurationException {
        Workflow workflow = this.xmlWorkflowFactory.getWorkflow(this.nonMappedCollection);
        TestCase.assertEquals((String)"defaultWorkflow", (String)workflow.getID());
    }

    @Test
    public void workflowMapping_MappedCollection() throws WorkflowConfigurationException {
        Workflow workflow = this.xmlWorkflowFactory.getWorkflow(this.mappedCollection);
        TestCase.assertEquals((String)"selectSingleReviewer", (String)workflow.getID());
    }
}

