/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.Console;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public final class CreateAdministrator {
    private final Context context = new Context();
    protected EPersonService ePersonService;
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public static void main(String[] argv) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        CreateAdministrator ca = new CreateAdministrator();
        options.addOption("e", "email", true, "administrator email address");
        options.addOption("f", "first", true, "administrator first name");
        options.addOption("h", "help", false, "explain create-administrator options");
        options.addOption("l", "last", true, "administrator last name");
        options.addOption("c", "language", true, "administrator language");
        options.addOption("p", "password", true, "administrator password");
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + "\nTry \"dspace create-administrator -h\" to print help information.");
            System.exit(1);
        }
        if (line.hasOption("e") && line.hasOption("f") && line.hasOption("l") && line.hasOption("c") && line.hasOption("p")) {
            ca.createAdministrator(line.getOptionValue("e"), line.getOptionValue("f"), line.getOptionValue("l"), line.getOptionValue("c"), line.getOptionValue("p"));
        } else {
            if (line.hasOption("h")) {
                String header = "\nA command-line tool for creating an initial administrator for setting up a DSpace site. Unless all the required parameters are passed it will prompt for an e-mail address, last name, first name and password from standard input.. An administrator group is then created and the data passed  in used to create an e-person in that group.\n\n";
                String footer = "\n";
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("dspace create-administrator", header, options, footer, true);
                return;
            }
            ca.negotiateAdministratorDetails(line);
        }
    }

    protected CreateAdministrator() throws Exception {
        this.ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    }

    protected void negotiateAdministratorDetails(CommandLine line) throws Exception {
        boolean dataOK;
        Console console = System.console();
        System.out.println("Creating an initial administrator account");
        String email = line.getOptionValue('e');
        String firstName = line.getOptionValue('f');
        String lastName = line.getOptionValue('l');
        String language = I18nUtil.getDefaultLocale().getLanguage();
        ConfigurationService cfg = DSpaceServicesFactory.getInstance().getConfigurationService();
        boolean flag = line.hasOption('p');
        char[] password = null;
        boolean bl = dataOK = line.hasOption('f') && line.hasOption('e') && line.hasOption('l');
        while (!dataOK) {
            System.out.print("E-mail address: ");
            System.out.flush();
            email = console.readLine();
            if (StringUtils.isBlank((CharSequence)email)) {
                System.out.println("Please provide an email address.");
                continue;
            }
            email = email.trim();
            System.out.print("First name: ");
            System.out.flush();
            firstName = console.readLine();
            if (firstName != null) {
                firstName = firstName.trim();
            }
            System.out.print("Last name: ");
            System.out.flush();
            lastName = console.readLine();
            if (lastName != null) {
                lastName = lastName.trim();
            }
            if (cfg.hasProperty("webui.supported.locales")) {
                System.out.println("Select one of the following languages: " + cfg.getProperty("webui.supported.locales"));
                System.out.print("Language: ");
                System.out.flush();
                language = console.readLine();
                if (language != null) {
                    language = language.trim();
                    language = I18nUtil.getSupportedLocale(new Locale(language)).getLanguage();
                }
            }
            System.out.print("Is the above data correct? (y or n): ");
            System.out.flush();
            String s = console.readLine();
            if (s == null || !(s = s.trim()).toLowerCase().startsWith("y")) continue;
            dataOK = true;
        }
        if (!flag) {
            password = this.getPassword(console);
            if (password == null) {
                return;
            }
        } else {
            password = line.getOptionValue("p").toCharArray();
        }
        this.createAdministrator(email, firstName, lastName, language, String.valueOf(password));
    }

    private char[] getPassword(Console console) {
        char[] password1 = null;
        char[] password2 = null;
        System.out.println("Password will not display on screen.");
        System.out.print("Password: ");
        System.out.flush();
        password1 = console.readPassword();
        System.out.print("Again to confirm: ");
        System.out.flush();
        password2 = console.readPassword();
        if (password1.length > 1 && Arrays.equals(password1, password2)) {
            Arrays.fill(password2, ' ');
            return password1;
        }
        System.out.println("Passwords don't match");
        return null;
    }

    protected void createAdministrator(String email, String first, String last, String language, String pw) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group admins = this.groupService.findByName(this.context, "Administrator");
        if (admins == null) {
            throw new IllegalStateException("Error, no admin group (group 1) found");
        }
        EPerson eperson = this.ePersonService.findByEmail(this.context, email);
        if (eperson == null) {
            eperson = this.ePersonService.create(this.context);
            eperson.setEmail(email);
            eperson.setCanLogIn(true);
            eperson.setRequireCertificate(false);
            eperson.setSelfRegistered(false);
        }
        eperson.setLastName(this.context, last);
        eperson.setFirstName(this.context, first);
        eperson.setLanguage(this.context, language);
        this.ePersonService.setPassword(eperson, pw);
        this.ePersonService.update(this.context, eperson);
        this.groupService.addMember(this.context, admins, eperson);
        this.groupService.update(this.context, admins);
        this.context.complete();
        System.out.println("Administrator account created");
    }
}

