/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.alerts;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.alerts.SystemWideAlert;
import org.dspace.alerts.dao.SystemWideAlertDAO;
import org.dspace.alerts.service.SystemWideAlertService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;

public class SystemWideAlertServiceImpl
implements SystemWideAlertService {
    private static final Logger log = LogManager.getLogger(SystemWideAlertService.class);
    @Autowired
    private SystemWideAlertDAO systemWideAlertDAO;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public SystemWideAlert create(Context context, String message, AllowSessionsEnum allowSessionsType, Date countdownTo, boolean active) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can create a system-wide alert");
        }
        SystemWideAlert systemWideAlert = new SystemWideAlert();
        systemWideAlert.setMessage(message);
        systemWideAlert.setAllowSessions(allowSessionsType);
        systemWideAlert.setCountdownTo(countdownTo);
        systemWideAlert.setActive(active);
        SystemWideAlert createdAlert = this.systemWideAlertDAO.create(context, systemWideAlert);
        log.info(LogHelper.getHeader(context, "system_wide_alert_create", "System Wide Alert has been created with message: '" + message + "' and ID " + createdAlert.getID() + " and allowSessionsType " + allowSessionsType + " and active set to " + active));
        return createdAlert;
    }

    @Override
    public SystemWideAlert find(Context context, int alertId) throws SQLException {
        return (SystemWideAlert)this.systemWideAlertDAO.findByID(context, SystemWideAlert.class, alertId);
    }

    @Override
    public List<SystemWideAlert> findAll(Context context) throws SQLException {
        return this.systemWideAlertDAO.findAll(context, SystemWideAlert.class);
    }

    @Override
    public List<SystemWideAlert> findAll(Context context, int limit, int offset) throws SQLException {
        return this.systemWideAlertDAO.findAll(context, limit, offset);
    }

    @Override
    public List<SystemWideAlert> findAllActive(Context context, int limit, int offset) throws SQLException {
        return this.systemWideAlertDAO.findAllActive(context, limit, offset);
    }

    @Override
    public void delete(Context context, SystemWideAlert systemWideAlert) throws SQLException, IOException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can create a system-wide alert");
        }
        this.systemWideAlertDAO.delete(context, systemWideAlert);
        log.info(LogHelper.getHeader(context, "system_wide_alert_create", "System Wide Alert with ID " + systemWideAlert.getID() + " has been deleted"));
    }

    @Override
    public void update(Context context, SystemWideAlert systemWideAlert) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can create a system-wide alert");
        }
        this.systemWideAlertDAO.save(context, systemWideAlert);
    }

    @Override
    public boolean canNonAdminUserLogin(Context context) throws SQLException {
        List<SystemWideAlert> active = this.findAllActive(context, 1, 0);
        if (active == null || active.isEmpty()) {
            return true;
        }
        return active.get(0).getAllowSessions() == AllowSessionsEnum.ALLOW_ALL_SESSIONS;
    }

    @Override
    public boolean canUserMaintainSession(Context context, EPerson ePerson) throws SQLException {
        if (this.authorizeService.isAdmin(context, ePerson)) {
            return true;
        }
        List<SystemWideAlert> active = this.findAllActive(context, 1, 0);
        if (active == null || active.isEmpty()) {
            return true;
        }
        return active.get(0).getAllowSessions() != AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY;
    }
}

