/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOFactory;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.web.ContextUtil;

public class ItemCounter {
    private static Logger log = LogManager.getLogger(ItemCounter.class);
    private ItemCountDAO dao;
    private Context context;
    private static ItemCounter instance;
    protected ItemService itemService;
    protected ConfigurationService configurationService;
    private boolean showStrengths;
    private boolean useCache;

    public ItemCounter(Context context) throws ItemCountException {
        this.context = context;
        this.dao = ItemCountDAOFactory.getInstance(this.context);
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.showStrengths = this.configurationService.getBooleanProperty("webui.strengths.show", false);
        this.useCache = this.configurationService.getBooleanProperty("webui.strengths.cache", true);
    }

    public static ItemCounter getInstance() throws ItemCountException {
        if (instance == null) {
            instance = new ItemCounter(ContextUtil.obtainCurrentRequestContext());
        }
        return instance;
    }

    public int getCount(DSpaceObject dso) throws ItemCountException {
        if (!this.showStrengths) {
            return -1;
        }
        if (this.useCache) {
            return this.dao.getCount(dso);
        }
        if (dso instanceof Collection) {
            try {
                return this.itemService.countItems(this.context, (Collection)dso);
            }
            catch (SQLException e) {
                log.error("caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        if (dso instanceof Community) {
            try {
                return this.itemService.countItems(this.context, (Community)dso);
            }
            catch (SQLException e) {
                log.error("caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        return 0;
    }
}

