/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.comparator.NameAscendingComparator;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.eperson.Group;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="community")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, include="non-lazy")
public class Community
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="community_id", insertable=false, updatable=false)
    private Integer legacyId;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="community2community", joinColumns={@JoinColumn(name="parent_comm_id")}, inverseJoinColumns={@JoinColumn(name="child_comm_id")})
    private final Set<Community> subCommunities = new HashSet<Community>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="subCommunities")
    private final Set<Community> parentCommunities = new HashSet<Community>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="communities", cascade={CascadeType.PERSIST})
    private final Set<Collection> collections = new HashSet<Collection>();
    @OneToOne
    @JoinColumn(name="admin")
    private Group admins;
    @OneToOne
    @JoinColumn(name="logo_bitstream_id")
    private Bitstream logo = null;
    @Transient
    protected transient CommunityService communityService;

    protected Community() {
    }

    protected Community(UUID uuid) {
        this.predefinedUUID = uuid;
    }

    void addSubCommunity(Community subCommunity) {
        this.subCommunities.add(subCommunity);
        this.setModified();
    }

    public void removeSubCommunity(Community subCommunity) {
        this.subCommunities.remove(subCommunity);
        this.setModified();
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    void setLogo(Bitstream logo) {
        this.logo = logo;
        this.setModified();
    }

    public Group getAdministrators() {
        return this.admins;
    }

    void setAdmins(Group admins) {
        this.admins = admins;
        this.setModified();
    }

    public List<Collection> getCollections() {
        Collection[] output = this.collections.toArray(new Collection[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    void addCollection(Collection collection) {
        this.collections.add(collection);
    }

    void removeCollection(Collection collection) {
        this.collections.remove(collection);
    }

    public List<Community> getSubcommunities() {
        Community[] output = this.subCommunities.toArray(new Community[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    public List<Community> getParentCommunities() {
        Community[] output = this.parentCommunities.toArray(new Community[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    void addParentCommunity(Community parentCommunity) {
        this.parentCommunities.add(parentCommunity);
    }

    void clearParentCommunities() {
        this.parentCommunities.clear();
    }

    public void removeParentCommunity(Community parentCommunity) {
        this.parentCommunities.remove(parentCommunity);
        this.setModified();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Community)) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        Community otherCommunity = (Community)other;
        return this.getID().equals(otherCommunity.getID());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getID()).toHashCode();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getName() {
        String value = this.getCommunityService().getMetadataFirstValue(this, MetadataSchemaEnum.DC.getName(), "title", null, "*");
        return value == null ? "" : value;
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    private CommunityService getCommunityService() {
        if (this.communityService == null) {
            this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        }
        return this.communityService;
    }

    public int countArchivedItems() {
        try {
            return this.communityService.countArchivedItems(this);
        }
        catch (ItemCountException e) {
            throw new RuntimeException(e);
        }
    }
}

