/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.indexobject.IndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableInProgressSubmission;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.CollectionIndexFactory;
import org.dspace.discovery.indexobject.factory.InprogressSubmissionIndexFactory;
import org.dspace.discovery.indexobject.factory.ItemIndexFactory;
import org.dspace.eperson.EPerson;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.service.SupervisionOrderService;
import org.dspace.util.SolrUtils;
import org.dspace.workflow.WorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class InprogressSubmissionIndexFactoryImpl<T extends IndexableInProgressSubmission, S extends InProgressSubmission>
extends IndexFactoryImpl<T, S>
implements InprogressSubmissionIndexFactory<T, S> {
    @Autowired
    protected CollectionIndexFactory indexableCollectionService;
    @Autowired
    protected ItemIndexFactory indexableItemService;
    @Autowired
    protected SupervisionOrderService supervisionOrderService;

    @Override
    public SolrInputDocument buildDocument(Context context, T indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        this.storeInprogressItemFields(context, doc, (InProgressSubmission)((IndexableInProgressSubmission)indexableObject).getIndexedObject());
        return doc;
    }

    @Override
    public void storeInprogressItemFields(Context context, SolrInputDocument doc, InProgressSubmission inProgressSubmission) throws SQLException, IOException {
        Item item = inProgressSubmission.getItem();
        doc.addField("lastModified", (Object)SolrUtils.getDateFormatter().format(item.getLastModified()));
        EPerson submitter = inProgressSubmission.getSubmitter();
        if (submitter != null) {
            this.addFacetIndex(doc, "submitter", submitter.getID().toString(), submitter.getFullName());
        }
        this.addSupervisedByFacetIndex(context, item, doc);
        doc.addField("inprogress.item", (Object)new IndexableItem(inProgressSubmission.getItem()).getUniqueIndexID());
        List<String> locations = this.indexableCollectionService.getCollectionLocations(context, inProgressSubmission.getCollection());
        locations.add("l" + inProgressSubmission.getCollection().getID());
        List<DiscoveryConfiguration> discoveryConfigurations = inProgressSubmission instanceof WorkflowItem ? SearchUtils.getAllDiscoveryConfigurations(context, (WorkflowItem)inProgressSubmission) : (inProgressSubmission instanceof WorkspaceItem ? SearchUtils.getAllDiscoveryConfigurations(context, (WorkspaceItem)inProgressSubmission) : SearchUtils.getAllDiscoveryConfigurations(context, item));
        this.indexableItemService.addDiscoveryFields(doc, context, item, discoveryConfigurations);
        this.indexableCollectionService.storeCommunityCollectionLocations(doc, locations);
    }

    private void addSupervisedByFacetIndex(Context context, Item item, SolrInputDocument doc) throws SQLException {
        List<SupervisionOrder> supervisionOrders = this.supervisionOrderService.findByItem(context, item);
        for (SupervisionOrder supervisionOrder : supervisionOrders) {
            this.addFacetIndex(doc, "supervisedBy", supervisionOrder.getGroup().getID().toString(), supervisionOrder.getGroup().getName());
        }
    }
}

