/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.subscriptions.objectupdates;

import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.FrequencyType;
import org.dspace.subscriptions.service.DSpaceObjectUpdates;
import org.springframework.beans.factory.annotation.Autowired;

public class CommunityUpdates
implements DSpaceObjectUpdates {
    @Autowired
    private SearchService searchService;

    @Override
    public List<IndexableObject> findUpdates(Context context, DSpaceObject dSpaceObject, String frequency) throws SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        this.getDefaultFilterQueries().stream().forEach(fq -> discoverQuery.addFilterQueries((String)fq));
        discoverQuery.addFilterQueries("location.comm:(" + dSpaceObject.getID() + ")");
        discoverQuery.addFilterQueries("lastModified:" + FrequencyType.findLastFrequency(frequency));
        DiscoverResult discoverResult = this.searchService.search(context, discoverQuery);
        return discoverResult.getIndexableObjects();
    }
}

