/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.dspace.AbstractUnitTest;
import org.dspace.app.mediafilter.TikaTextExtractionFilter;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Test;

public class TikaTextExtractionFilterTest
extends AbstractUnitTest {
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Test
    public void testGetDestinationStreamWithUseTempFile() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        this.configurationService.setProperty("textextractor.use-temp-file", (Object)"true");
        InputStream source = this.getClass().getResourceAsStream("test.pdf");
        InputStream result = instance.getDestinationStream(null, source, false);
        String tempFileExtractedText = TikaTextExtractionFilterTest.readAll(result);
        Assert.assertTrue((String)"Known content was not found in .pdf", (boolean)tempFileExtractedText.contains("quick brown fox"));
        this.configurationService.setProperty("textextractor.use-temp-file", (Object)"false");
        source = this.getClass().getResourceAsStream("test.pdf");
        result = instance.getDestinationStream(null, source, false);
        String inMemoryExtractedText = TikaTextExtractionFilterTest.readAll(result);
        Assert.assertEquals((String)"Extracted text via temp file is the same as in-memory.", (Object)inMemoryExtractedText, (Object)tempFileExtractedText);
    }

    @Test
    public void testGetDestinationStreamWithMaxChars() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        this.configurationService.setProperty("textextractor.max-chars", (Object)"100");
        InputStream source = this.getClass().getResourceAsStream("test.pdf");
        InputStream result = instance.getDestinationStream(null, source, false);
        String extractedText = TikaTextExtractionFilterTest.readAll(result);
        Assert.assertEquals((long)100L, (long)extractedText.length());
        Assert.assertTrue((String)"Known beginning content was found", (boolean)extractedText.contains("This is a text."));
        Assert.assertFalse((String)"Known ending content was not found", (boolean)extractedText.contains("Emergency Broadcast System"));
    }

    @Test
    public void testGetDestinationStreamWithDoc() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.doc");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .doc", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithDocx() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.docx");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .docx", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithODT() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.odt");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .odt", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithRTF() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.rtf");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .rtf", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithPDF() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.pdf");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .pdf", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithHTML() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.html");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .html", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithTxt() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.txt");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .txt", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithCsv() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.csv");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .csv", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("data3,3"));
    }

    @Test
    public void testGetDestinationStreamWithXLS() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.xls");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .xls", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("data3,3"));
    }

    @Test
    public void testGetDestinationStreamWithXLSX() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.xlsx");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .xlsx", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("data3,3"));
    }

    @Test
    public void testGetDestinationStreamWithODS() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.ods");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .ods", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("Data on the second sheet"));
    }

    @Test
    public void testGetDestinationStreamWithPPT() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.ppt");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .ppt", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithPPTX() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.pptx");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .pptx", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    @Test
    public void testGetDestinationStreamWithODP() throws Exception {
        TikaTextExtractionFilter instance = new TikaTextExtractionFilter();
        InputStream source = this.getClass().getResourceAsStream("test.odp");
        InputStream result = instance.getDestinationStream(null, source, false);
        Assert.assertTrue((String)"Known content was not found in .odp", (boolean)TikaTextExtractionFilterTest.readAll(result).contains("quick brown fox"));
    }

    private static String readAll(InputStream stream) throws IOException {
        return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
    }
}

