/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.packager;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Element;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PackagerIT
extends AbstractIntegrationTestWithDatabase {
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected static final InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected ConfigurationService configService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected Community child1;
    protected Collection col1;
    protected Item article;
    File tempFile;

    @Before
    public void setup() throws IOException {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community").build();
        this.col1 = CollectionBuilder.createCollection(this.context, this.child1).withName("Collection 2").withEntityType("Publication").build();
        this.article = ItemBuilder.createItem(this.context, this.col1).withTitle("Article").withIssueDate("2017-10-17").build();
        this.tempFile = File.createTempFile("packagerExportTest", ".zip");
        this.context.restoreAuthSystemState();
    }

    @Override
    @After
    public void destroy() throws Exception {
        this.tempFile.delete();
        super.destroy();
    }

    @Test
    public void packagerExportUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.performExportScript(this.article.getHandle(), this.tempFile);
        Assert.assertTrue((this.tempFile.length() > 0L ? 1 : 0) != 0);
        String idStr = this.getID();
        Assert.assertEquals((Object)idStr, (Object)this.article.getID().toString());
    }

    @Test
    public void packagerImportUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.performExportScript(this.article.getHandle(), this.tempFile);
        String idStr = this.getID();
        this.itemService.delete(this.context, (DSpaceObject)this.article);
        this.performImportScript(this.tempFile);
        Item item = (Item)this.itemService.find(this.context, UUID.fromString(idStr));
        Assert.assertNotNull((Object)item);
    }

    @Test
    public void packagerImportColUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configService.setProperty("upload.temp.dir", (Object)this.tempFile.getParent());
        this.performExportScript(this.col1.getHandle(), this.tempFile);
        String idStr = this.getID();
        this.collectionService.delete(this.context, (DSpaceObject)this.col1);
        this.performImportScript(this.tempFile);
        Collection collection = (Collection)this.collectionService.find(this.context, UUID.fromString(idStr));
        Assert.assertNotNull((Object)collection);
    }

    @Test
    public void packagerImportComUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configService.setProperty("upload.temp.dir", (Object)this.tempFile.getParent());
        this.performExportScript(this.child1.getHandle(), this.tempFile);
        String idStr = this.getID();
        this.communityService.delete(this.context, (DSpaceObject)this.child1);
        this.performImportScript(this.tempFile);
        Community community = (Community)this.communityService.find(this.context, UUID.fromString(idStr));
        Assert.assertNotNull((Object)community);
    }

    @Test
    public void packagerUUIDAlreadyExistTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.performExportScript(this.article.getHandle(), this.tempFile);
        this.performImportScript(this.tempFile);
        Iterator items = this.itemService.findByCollection(this.context, this.col1);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)items));
    }

    @Test
    public void packagerUUIDAlreadyExistWithoutForceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.performExportScript(this.article.getHandle(), this.tempFile);
        UUID id = this.article.getID();
        this.itemService.delete(this.context, (DSpaceObject)this.article);
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.col1, id, false, false);
        installItemService.installItem(this.context, (InProgressSubmission)workspaceItem, "123456789/0100");
        this.performImportNoForceScript(this.tempFile);
        Iterator items = this.itemService.findByCollection(this.context, this.col1);
        Item testItem = (Item)items.next();
        Assert.assertFalse((boolean)items.hasNext());
        Assert.assertEquals((Object)"123456789/0100", (Object)testItem.getHandle());
        this.itemService.delete(this.context, (DSpaceObject)testItem);
    }

    private String getID() throws IOException, MetadataValidationException {
        Element mets;
        String idStr;
        METSManifest manifest = null;
        ZipFile zip = new ZipFile(this.tempFile);
        ZipEntry manifestEntry = zip.getEntry("mets.xml");
        if (manifestEntry != null) {
            manifest = METSManifest.create((InputStream)zip.getInputStream(manifestEntry), (boolean)false, (String)"AIP");
        }
        if ((idStr = (mets = manifest.getMets()).getAttributeValue("ID")).contains("DB-ID-")) {
            idStr = idStr.substring(idStr.lastIndexOf("DB-ID-") + 6, idStr.length());
        }
        return idStr;
    }

    private void performExportScript(String handle, File outputFile) throws Exception {
        this.runDSpaceScript("packager", "-d", "-e", "admin@email.com", "-i", handle, "-t", "AIP", outputFile.getPath());
    }

    private void performImportNoForceScript(File outputFile) throws Exception {
        this.runDSpaceScript("packager", "-r", "-u", "-e", "admin@email.com", "-t", "AIP", outputFile.getPath());
    }

    private void performImportScript(File outputFile) throws Exception {
        this.runDSpaceScript("packager", "-r", "-f", "-u", "-e", "admin@email.com", "-t", "AIP", outputFile.getPath());
    }
}

