/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.RegexPatternUtils;
import org.junit.Assert;
import org.junit.Test;

public class RegexPatternUtilsTest
extends AbstractUnitTest {
    @Test
    public void testValidRegexWithFlag() {
        String insensitiveWord = "/[a-z]+/i";
        Pattern computePattern = Pattern.compile("/[a-z]+/i");
        Assert.assertNotNull((Object)computePattern);
        Matcher matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("DSpace");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Community");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("/wrongpattern/i");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("001");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("?/'`}{][<>.,");
        Assert.assertFalse((boolean)matcher.matches());
        computePattern = RegexPatternUtils.computePattern((String)"/[a-z]+/i");
        Assert.assertNotNull((Object)computePattern);
        matcher = computePattern.matcher("Hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("DSpace");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("Community");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("/wrong-pattern/i");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("001");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("?/'`}{][<>.,");
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testRegexWithoutFlag() {
        String sensitiveWord = "[a-z]+";
        Pattern computePattern = RegexPatternUtils.computePattern((String)"[a-z]+");
        Assert.assertNotNull((Object)computePattern);
        Matcher matcher = computePattern.matcher("hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("dspace");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("community");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("DSpace");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Community");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("/wrongpattern/i");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("001");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("?/'`}{][<>.,");
        Assert.assertFalse((boolean)matcher.matches());
        String sensitiveWordWithDelimiter = "/[a-z]+/";
        computePattern = RegexPatternUtils.computePattern((String)"/[a-z]+/");
        Assert.assertNotNull((Object)computePattern);
        matcher = computePattern.matcher("hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("dspace");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("community");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("DSpace");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Community");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("/wrongpattern/i");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("001");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("?/'`}{][<>.,");
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testWithFuzzyRegex() {
        String fuzzyRegex = "/[a-z]+";
        Pattern computePattern = RegexPatternUtils.computePattern((String)fuzzyRegex);
        Assert.assertNotNull((Object)computePattern);
        Matcher matcher = computePattern.matcher("/hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        fuzzyRegex = "[a-z]+/";
        computePattern = RegexPatternUtils.computePattern((String)fuzzyRegex);
        matcher = computePattern.matcher("hello/");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("/hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        fuzzyRegex = "\\\\[a-z]+\\\\";
        computePattern = RegexPatternUtils.computePattern((String)fuzzyRegex);
        matcher = computePattern.matcher("\\hello\\");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("/hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
        fuzzyRegex = "\\/[a-z]+\\/";
        computePattern = RegexPatternUtils.computePattern((String)fuzzyRegex);
        matcher = computePattern.matcher("/hello/");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("/hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("hello");
        Assert.assertFalse((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testInvalidRegex() {
        String invalidSensitive = "[a-z+";
        Assert.assertThrows(PatternSyntaxException.class, () -> RegexPatternUtils.computePattern((String)invalidSensitive));
        String invalidRange = "a{1-";
        Assert.assertThrows(PatternSyntaxException.class, () -> RegexPatternUtils.computePattern((String)invalidRange));
        String invalidGroupPattern = "(abc";
        Assert.assertThrows(PatternSyntaxException.class, () -> RegexPatternUtils.computePattern((String)invalidGroupPattern));
        String emptyPattern = "";
        Pattern computePattern = RegexPatternUtils.computePattern((String)emptyPattern);
        Assert.assertNull((Object)computePattern);
        String blankPattern = "                      ";
        computePattern = RegexPatternUtils.computePattern((String)blankPattern);
        Assert.assertNull((Object)computePattern);
        String nullPattern = null;
        computePattern = RegexPatternUtils.computePattern(nullPattern);
        Assert.assertNull((Object)computePattern);
    }

    @Test
    public void testMultiFlagRegex() {
        String multilineSensitive = "/[a-z]+/gi";
        Pattern computePattern = RegexPatternUtils.computePattern((String)multilineSensitive);
        Assert.assertNotNull((Object)computePattern);
        Matcher matcher = computePattern.matcher("hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("Hello");
        Assert.assertTrue((boolean)matcher.matches());
        multilineSensitive = "/[a-z]+/gim";
        computePattern = RegexPatternUtils.computePattern((String)multilineSensitive);
        Assert.assertNotNull((Object)computePattern);
        matcher = computePattern.matcher("Hello" + System.lineSeparator() + "Everyone");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"Hello", (Object)matcher.group());
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"Everyone", (Object)matcher.group());
        matcher = computePattern.matcher("hello");
        Assert.assertTrue((boolean)matcher.matches());
        matcher = computePattern.matcher("HELLO");
        Assert.assertTrue((boolean)matcher.matches());
    }
}

