/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.alerts.SystemWideAlert;
import org.dspace.alerts.service.SystemWideAlertService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;

public class SystemWideAlertBuilder
extends AbstractBuilder<SystemWideAlert, SystemWideAlertService> {
    private SystemWideAlert systemWideAlert;

    protected SystemWideAlertBuilder(Context context) {
        super(context);
    }

    public static SystemWideAlertBuilder createSystemWideAlert(Context context, String message) throws SQLException, AuthorizeException {
        SystemWideAlertBuilder systemWideAlertBuilder = new SystemWideAlertBuilder(context);
        return systemWideAlertBuilder.create(context, message, AllowSessionsEnum.ALLOW_ALL_SESSIONS, null, false);
    }

    private SystemWideAlertBuilder create(Context context, String message, AllowSessionsEnum allowSessionsType, Date countdownTo, boolean active) throws SQLException, AuthorizeException {
        this.context = context;
        this.systemWideAlert = systemWideAlertService.create(context, message, allowSessionsType, countdownTo, active);
        return this;
    }

    public SystemWideAlertBuilder withAllowSessions(AllowSessionsEnum allowSessionsType) {
        this.systemWideAlert.setAllowSessions(allowSessionsType);
        return this;
    }

    public SystemWideAlertBuilder withCountdownDate(Date countdownTo) {
        this.systemWideAlert.setCountdownTo(countdownTo);
        return this;
    }

    public SystemWideAlertBuilder isActive(boolean isActive) {
        this.systemWideAlert.setActive(isActive);
        return this;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.systemWideAlert = (SystemWideAlert)c.reloadEntity((ReloadableEntity)this.systemWideAlert);
            if (this.systemWideAlert != null) {
                this.delete(c, this.systemWideAlert);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public SystemWideAlert build() {
        try {
            systemWideAlertService.update(this.context, this.systemWideAlert);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            return null;
        }
        return this.systemWideAlert;
    }

    @Override
    protected SystemWideAlertService getService() {
        return systemWideAlertService;
    }

    @Override
    public void delete(Context c, SystemWideAlert alert) throws Exception {
        if (alert != null) {
            this.getService().delete(c, alert);
        }
    }
}

