/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDSpaceObjectTest
extends AbstractUnitTest {
    protected DSpaceObject dspaceObject;
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();

    @Override
    @After
    public void destroy() {
        this.dspaceObject = null;
        super.destroy();
    }

    @Test
    public void testClearDetails() {
        String[] testData;
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        String details = this.dspaceObject.getDetails();
        this.dspaceObject.clearDetails();
        MatcherAssert.assertThat((String)"testClearDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testClearDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)details)));
    }

    @Test
    public void testAddDetails() {
        String[] testData;
        this.dspaceObject.clearDetails();
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        MatcherAssert.assertThat((String)"testAddDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"details 1, details 2, details 3")));
        MatcherAssert.assertThat((String)"testAddDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
    }

    @Test
    public void testGetDetails() {
        String[] testData;
        this.dspaceObject.clearDetails();
        MatcherAssert.assertThat((String)"testGetDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.nullValue());
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        MatcherAssert.assertThat((String)"testGetDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"details 1, details 2, details 3")));
    }

    @Test
    public void testFind() throws SQLException {
        DSpaceObjectService dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(this.dspaceObject.getType());
        if (this.dspaceObject instanceof Bitstream) {
            MatcherAssert.assertThat((String)"BITSTREAM type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Bundle) {
            MatcherAssert.assertThat((String)"BUNDLE type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Item) {
            MatcherAssert.assertThat((String)"ITEM type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Collection) {
            MatcherAssert.assertThat((String)"COLLECTION type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Community) {
            MatcherAssert.assertThat((String)"COMMUNITY type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Group) {
            MatcherAssert.assertThat((String)"GROUP type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof EPerson) {
            MatcherAssert.assertThat((String)"EPERSON type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Site) {
            MatcherAssert.assertThat((String)"SITE type", (Object)dSpaceObjectService.find(this.context, this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else {
            MatcherAssert.assertThat((String)"Unknown type", (Object)dSpaceObjectService, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testGetAdminObject() throws SQLException {
        DSpaceObjectService dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(this.dspaceObject.getType());
        MatcherAssert.assertThat((String)"READ action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"WRITE action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"DELETE action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"ADD action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 3), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"REMOVE action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 4), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"WORKFLOW_STEP_1 action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 5), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"WORKFLOW_STEP_2 action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 6), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"WORKFLOW_STEP_3 action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 7), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"WORKFLOW_ABORT action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 8), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"DEFAULT_BITSTREAM_READ action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 9), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        MatcherAssert.assertThat((String)"DEFAULT_ITEM_READ action", (Object)dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 10), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetAdminObjectwithException() throws SQLException {
        if (this.dspaceObject instanceof Bundle || this.dspaceObject instanceof Community || this.dspaceObject instanceof Collection || this.dspaceObject instanceof Item) {
            throw new IllegalArgumentException();
        }
        DSpaceObjectService dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(this.dspaceObject.getType());
        dSpaceObjectService.getAdminObject(this.context, this.dspaceObject, 11);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testGetParentObject() throws SQLException {
        DSpaceObjectService dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(this.dspaceObject.getType());
        MatcherAssert.assertThat((String)"testGetParentObject 0", (Object)dSpaceObjectService.getParentObject(this.context, this.dspaceObject), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public abstract void testGetType();

    @Test
    public abstract void testGetID();

    @Test
    public abstract void testGetHandle();

    @Test
    public abstract void testGetName();
}

