/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.VersionedHandleIdentifierProviderWithCanonicalHandles;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CreateMissingIdentifiers
extends AbstractCurationTask {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        Context context;
        boolean compatible;
        if (!(dso instanceof Item)) {
            return 2;
        }
        boolean bl = compatible = DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(VersionedHandleIdentifierProviderWithCanonicalHandles.class.getCanonicalName(), IdentifierProvider.class) == null;
        if (!compatible) {
            this.setResult("This task is not compatible with VersionedHandleIdentifierProviderWithCanonicalHandles");
            return -1;
        }
        String typeText = Constants.typeText[dso.getType()];
        try {
            context = Curator.curationContext();
        }
        catch (SQLException ex) {
            this.report("Could not get the curation Context:  " + ex.getMessage());
            return -1;
        }
        IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
        try {
            identifierService.register(context, dso);
        }
        catch (SQLException | AuthorizeException | IdentifierException ex) {
            String message = ex.getMessage();
            this.report(String.format("Identifier(s) not minted for %s %s:  %s%n", typeText, dso.getID().toString(), message));
            LOG.error("Identifier(s) not minted:  {}", (Object)message);
            return -1;
        }
        this.report(String.format("%s %s registered.%n", typeText, dso.getID().toString()));
        return 0;
    }
}

