/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.curate.Curator;
import org.dspace.curate.service.XmlWorkflowCuratorService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.CurationTaskConfig;
import org.dspace.workflow.FlowStep;
import org.dspace.workflow.Task;
import org.dspace.workflow.TaskSet;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XmlWorkflowCuratorServiceImpl
implements XmlWorkflowCuratorService {
    private static final Logger LOG = LogManager.getLogger();
    @Autowired(required=true)
    protected XmlWorkflowFactory workflowFactory;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected CurationTaskConfig curationTaskConfig;
    @Autowired(required=true)
    protected XmlWorkflowService workflowService;
    @Autowired(required=true)
    protected XmlWorkflowItemService workflowItemService;
    private final StringBuilder reporter = new StringBuilder();

    @Override
    public boolean needsCuration(Context c, XmlWorkflowItem wfi) throws SQLException, IOException {
        return this.getFlowStep(c, wfi) != null;
    }

    @Override
    public boolean doCuration(Context c, XmlWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        Curator curator = new Curator();
        curator.setReporter(this.reporter);
        c.turnOffAuthorisationSystem();
        boolean wasAnonymous = false;
        if (null == c.getCurrentUser()) {
            wasAnonymous = true;
            c.setCurrentUser(this.ePersonService.getSystemEPerson(c));
        }
        boolean failedP = this.curate(curator, c, wfi);
        if (wasAnonymous) {
            c.setCurrentUser(null);
        }
        c.restoreAuthSystemState();
        return failedP;
    }

    @Override
    public boolean curate(Curator curator, Context c, String wfId) throws AuthorizeException, IOException, SQLException {
        XmlWorkflowItem wfi = (XmlWorkflowItem)this.workflowItemService.find(c, Integer.parseInt(wfId));
        if (wfi != null) {
            return this.curate(curator, c, wfi);
        }
        LOG.warn(LogHelper.getHeader(c, "No workflow item found for id: {}", null), (Object)wfId);
        return false;
    }

    @Override
    public boolean curate(Curator curator, Context c, XmlWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        FlowStep step = this.getFlowStep(c, wfi);
        if (step != null) {
            Item item = wfi.getItem();
            item.setOwningCollection(wfi.getCollection());
            for (Task task : step.tasks) {
                curator.addTask(task.name);
                if (StringUtils.isNotEmpty((CharSequence)step.queue)) {
                    curator.queue(c, item.getID().toString(), step.queue);
                } else {
                    curator.curate(c, item);
                    int status = curator.getStatus(task.name);
                    String result = curator.getResult(task.name);
                    String action = "none";
                    switch (status) {
                        case 1: {
                            if (task.powers.contains("reject")) {
                                action = "reject";
                            }
                            this.notifyContacts(c, wfi, task, "fail", action, result);
                            if (!"reject".equals(action)) break;
                            this.workflowService.sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), null, task.name + ": " + result);
                            return false;
                        }
                        case 0: {
                            if (task.powers.contains("approve")) {
                                action = "approve";
                            }
                            this.notifyContacts(c, wfi, task, "success", action, result);
                            if (!"approve".equals(action)) break;
                            return true;
                        }
                        case -1: {
                            this.notifyContacts(c, wfi, task, "error", action, result);
                            break;
                        }
                    }
                }
                curator.clear();
            }
            if (this.reporter.length() > 0) {
                LOG.info("Curation tasks over item {} for step {} report:%n{}", new Supplier[]{() -> wfi.getItem().getID(), () -> step.step, () -> this.reporter.toString()});
            }
        }
        return true;
    }

    protected FlowStep getFlowStep(Context c, XmlWorkflowItem wfi) throws SQLException, IOException {
        if (this.claimedTaskService.find(c, wfi).isEmpty()) {
            Collection coll = wfi.getCollection();
            String taskSetName = this.curationTaskConfig.containsKey(coll.getHandle()) ? coll.getHandle() : "default";
            TaskSet ts = this.curationTaskConfig.findTaskSet(taskSetName);
            return ts.steps.isEmpty() ? null : ts.steps.get(0);
        }
        ClaimedTask claimedTask = this.claimedTaskService.findByWorkflowIdAndEPerson(c, wfi, c.getCurrentUser());
        if (claimedTask != null) {
            Collection coll = wfi.getCollection();
            String taskSetName = this.curationTaskConfig.containsKey(coll.getHandle()) ? coll.getHandle() : "default";
            TaskSet ts = this.curationTaskConfig.findTaskSet(taskSetName);
            for (FlowStep fstep : ts.steps) {
                if (!fstep.step.equals(claimedTask.getStepID())) continue;
                return fstep;
            }
        }
        return null;
    }

    protected void notifyContacts(Context c, XmlWorkflowItem wfi, Task task, String status, String action, String message) throws AuthorizeException, IOException, SQLException {
        List<EPerson> epa = this.resolveContacts(c, task.getContacts(status), wfi);
        if (!epa.isEmpty()) {
            this.workflowService.notifyOfCuration(c, wfi, epa, task.name, action, message);
        } else {
            LOG.warn("No contacts were found for workflow item {}:  task {} returned action {} with message {}", (Object)wfi.getID(), (Object)task.name, (Object)action, (Object)message);
        }
    }

    protected List<EPerson> resolveContacts(Context c, List<String> contacts, XmlWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        ArrayList<EPerson> epList = new ArrayList<EPerson>();
        for (String contact : contacts) {
            if ("$flowgroup".equals(contact)) {
                Step step;
                String stepID = this.getFlowStep((Context)c, (XmlWorkflowItem)wfi).step;
                try {
                    Workflow workflow = this.workflowFactory.getWorkflow(wfi.getCollection());
                    step = workflow.getStep(stepID);
                }
                catch (WorkflowConfigurationException e) {
                    LOG.error("Failed to locate current workflow step for workflow item {}", (Object)String.valueOf(wfi.getID()), (Object)e);
                    return epList;
                }
                Role role = step.getRole();
                if (null != role) {
                    RoleMembers roleMembers = role.getMembers(c, wfi);
                    for (EPerson ep : roleMembers.getEPersons()) {
                        epList.add(ep);
                    }
                    for (Group group : roleMembers.getGroups()) {
                        epList.addAll(group.getMembers());
                    }
                    continue;
                }
                epList.add(this.ePersonService.getSystemEPerson(c));
                continue;
            }
            if ("$colladmin".equals(contact)) {
                Group adGroup = wfi.getCollection().getAdministrators();
                if (adGroup == null) continue;
                epList.addAll(this.groupService.allMembers(c, adGroup));
                continue;
            }
            if ("$siteadmin".equals(contact)) {
                EPerson siteEp = this.ePersonService.findByEmail(c, this.configurationService.getProperty("mail.admin"));
                if (siteEp == null) continue;
                epList.add(siteEp);
                continue;
            }
            if (contact.indexOf("@") > 0) {
                EPerson ep = this.ePersonService.findByEmail(c, contact);
                if (ep == null) continue;
                epList.add(ep);
                continue;
            }
            Group group = this.groupService.findByName(c, contact);
            if (group == null) continue;
            epList.addAll(this.groupService.allMembers(c, group));
        }
        return epList;
    }
}

