/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import javax.inject.Named;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.params.SolrParams;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.service.impl.HttpConnectionPoolService;
import org.dspace.services.ConfigurationService;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrSearchCore {
    private final Logger log = LogManager.getLogger();
    @Autowired
    protected IndexingService indexingService;
    @Autowired
    protected ConfigurationService configurationService;
    @Autowired
    @Named(value="solrHttpConnectionPoolService")
    protected HttpConnectionPoolService httpConnectionPoolService;
    protected SolrClient solr = null;
    public SolrRequest.METHOD REQUEST_METHOD = SolrRequest.METHOD.POST;

    public SolrClient getSolr() {
        if (this.solr == null) {
            this.initSolr();
        }
        if (this.solr.getClass().getSimpleName().equals("EmbeddedSolrServer")) {
            this.REQUEST_METHOD = SolrRequest.METHOD.GET;
        }
        return this.solr;
    }

    protected void initSolr() {
        if (this.solr == null) {
            UrlValidator urlValidator = new UrlValidator(8L);
            String solrService = this.configurationService.getProperty("discovery.search.server");
            if (urlValidator.isValid(solrService) || this.configurationService.getBooleanProperty("discovery.solr.url.validation.enabled", true)) {
                try {
                    this.log.debug("Solr URL: {}", (Object)solrService);
                    HttpSolrClient solrServer = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(solrService).withHttpClient((HttpClient)this.httpConnectionPoolService.getClient())).build();
                    solrServer.setBaseURL(solrService);
                    solrServer.setUseMultiPartPost(true);
                    SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:" + IndexableItem.TYPE + " AND search.resourceid:1");
                    solrQuery.setFields(new String[]{"search.resourcetype", "search.resourceid"});
                    solrServer.query((SolrParams)solrQuery, this.REQUEST_METHOD);
                    DatabaseUtils.checkReindexDiscovery(this.indexingService);
                    this.solr = solrServer;
                }
                catch (IOException | SolrServerException e) {
                    this.log.error("Error while initializing solr server {}", (Object)solrService, (Object)e);
                    throw new RuntimeException("Failed to contact Solr at " + solrService + " :  " + e.getMessage());
                }
            } else {
                this.log.error("Error while initializing solr, invalid url: {}", (Object)solrService);
            }
        }
    }
}

