/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.indexobject.IndexableDSpaceObject;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DiscoveryConfigurationService {
    private static final Logger log = LogManager.getLogger();
    private Map<String, DiscoveryConfiguration> map;
    private Map<Integer, List<String>> toIgnoreMetadataFields = new HashMap<Integer, List<String>>();
    private final Map<UUID, DiscoveryConfiguration> comColToDiscoveryConfigurationMap = new ConcurrentHashMap<UUID, DiscoveryConfiguration>();

    public Map<String, DiscoveryConfiguration> getMap() {
        return this.map;
    }

    public void setMap(Map<String, DiscoveryConfiguration> map) {
        this.map = map;
    }

    public Map<Integer, List<String>> getToIgnoreMetadataFields() {
        return this.toIgnoreMetadataFields;
    }

    public void setToIgnoreMetadataFields(Map<Integer, List<String>> toIgnoreMetadataFields) {
        this.toIgnoreMetadataFields = toIgnoreMetadataFields;
    }

    public DiscoveryConfiguration getDiscoveryConfiguration(Context context, IndexableObject indexableObject) {
        if (indexableObject == null) {
            return this.getDiscoveryConfiguration(null);
        }
        if (indexableObject instanceof IndexableDSpaceObject) {
            return this.getDiscoveryDSOConfiguration(context, (DSpaceObject)((IndexableDSpaceObject)indexableObject).getIndexedObject());
        }
        String name = indexableObject.getUniqueIndexID();
        return this.getDiscoveryConfiguration(name);
    }

    public DiscoveryConfiguration getDiscoveryDSOConfiguration(Context context, DSpaceObject dso) {
        if (dso == null) {
            return this.getDiscoveryConfiguration(null, true);
        }
        if (this.comColToDiscoveryConfigurationMap.containsKey(dso.getID())) {
            return this.comColToDiscoveryConfigurationMap.get(dso.getID());
        }
        DiscoveryConfiguration configuration = this.getDiscoveryConfiguration(dso.getHandle(), false);
        if (configuration == null) {
            DSpaceObjectService<DSpaceObject> dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
            DSpaceObject parentObject = null;
            try {
                parentObject = dSpaceObjectService.getParentObject(context, dso);
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            configuration = this.getDiscoveryDSOConfiguration(context, parentObject);
        }
        if (dso instanceof Community || dso instanceof Collection) {
            this.comColToDiscoveryConfigurationMap.put(dso.getID(), configuration);
        }
        return configuration;
    }

    public DiscoveryConfiguration getDiscoveryConfiguration(String name) {
        return this.getDiscoveryConfiguration(name, true);
    }

    public DiscoveryConfiguration getDiscoveryConfiguration(String name, boolean useDefault) {
        DiscoveryConfiguration result;
        DiscoveryConfiguration discoveryConfiguration = result = StringUtils.isBlank((CharSequence)name) ? null : this.getMap().get(name);
        if (result == null && useDefault) {
            result = this.getMap().get("default");
        }
        return result;
    }

    public DiscoveryConfiguration getDiscoveryConfigurationByNameOrIndexableObject(Context context, String configurationName, IndexableObject indexableObject) {
        if (StringUtils.isNotBlank((CharSequence)configurationName) && this.getMap().containsKey(configurationName)) {
            return this.getMap().get(configurationName);
        }
        return this.getDiscoveryConfiguration(context, indexableObject);
    }

    public List<DiscoveryConfiguration> getIndexAlwaysConfigurations() {
        ArrayList<DiscoveryConfiguration> configs = new ArrayList<DiscoveryConfiguration>();
        for (String key : this.map.keySet()) {
            DiscoveryConfiguration config = this.map.get(key);
            if (!config.isIndexAlways()) continue;
            configs.add(config);
        }
        return configs;
    }

    public List<DiscoverySearchFilterFacet> getAllFacetsConfig() {
        ArrayList<DiscoverySearchFilterFacet> configs = new ArrayList<DiscoverySearchFilterFacet>();
        for (String key : this.map.keySet()) {
            DiscoveryConfiguration config = this.map.get(key);
            configs.addAll(config.getSidebarFacets());
        }
        return configs;
    }

    public static void main(String[] args) {
        System.out.println(DSpaceServicesFactory.getInstance().getServiceManager().getServicesNames().size());
        DiscoveryConfigurationService mainService = (DiscoveryConfigurationService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
        for (String key : mainService.getMap().keySet()) {
            System.out.println(key);
            System.out.println("Facets:");
            DiscoveryConfiguration discoveryConfiguration = mainService.getMap().get(key);
            for (int i = 0; i < discoveryConfiguration.getSidebarFacets().size(); ++i) {
                DiscoverySearchFilterFacet sidebarFacet = discoveryConfiguration.getSidebarFacets().get(i);
                System.out.println("\t" + sidebarFacet.getIndexFieldName());
                for (int j = 0; j < sidebarFacet.getMetadataFields().size(); ++j) {
                    String metadataField = sidebarFacet.getMetadataFields().get(j);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Search filters");
            List<DiscoverySearchFilter> searchFilters = discoveryConfiguration.getSearchFilters();
            for (DiscoverySearchFilter searchFilter : searchFilters) {
                for (int i = 0; i < searchFilter.getMetadataFields().size(); ++i) {
                    String metadataField = searchFilter.getMetadataFields().get(i);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Recent submissions configuration:");
            DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration();
            System.out.println("\tMetadata sort field: " + recentSubmissionConfiguration.getMetadataSortField());
            System.out.println("\tMax recent submissions: " + recentSubmissionConfiguration.getMax());
            List<String> defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
            if (0 >= defaultFilterQueries.size()) continue;
            System.out.println("Default filter queries");
            for (String fq : defaultFilterQueries) {
                System.out.println("\t" + fq);
            }
        }
    }

    public List<DiscoveryConfiguration> getDiscoveryConfigurationWithPrefixName(String prefixConfigurationName) {
        ArrayList<DiscoveryConfiguration> discoveryConfigurationList = new ArrayList<DiscoveryConfiguration>();
        if (StringUtils.isNotBlank((CharSequence)prefixConfigurationName)) {
            for (String key : this.map.keySet()) {
                if (!key.equals(prefixConfigurationName) && !key.startsWith(prefixConfigurationName)) continue;
                DiscoveryConfiguration config = this.map.get(key);
                discoveryConfigurationList.add(config);
            }
        }
        return discoveryConfigurationList;
    }
}

