/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Community;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.indexobject.DSpaceObjectIndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.factory.CommunityIndexFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommunityIndexFactoryImpl
extends DSpaceObjectIndexFactoryImpl<IndexableCommunity, Community>
implements CommunityIndexFactory {
    @Autowired(required=true)
    protected CommunityService communityService;

    @Override
    public Iterator<IndexableCommunity> findAll(Context context) throws SQLException {
        final Iterator<Community> communities = this.communityService.findAll(context).iterator();
        return new Iterator<IndexableCommunity>(){

            @Override
            public boolean hasNext() {
                return communities.hasNext();
            }

            @Override
            public IndexableCommunity next() {
                return new IndexableCommunity((Community)communities.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableCommunity.TYPE;
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableCommunity indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        Community community = (Community)indexableObject.getIndexedObject();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(context, community);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.communityService.getMetadataFirstValue(community, CommunityService.MD_INTRODUCTORY_TEXT, "*");
        String description_abstract = this.communityService.getMetadataFirstValue(community, CommunityService.MD_SHORT_DESCRIPTION, "*");
        String description_table = this.communityService.getMetadataFirstValue(community, CommunityService.MD_SIDEBAR_TEXT, "*");
        String rights = this.communityService.getMetadataFirstValue(community, CommunityService.MD_COPYRIGHT_TEXT, "*");
        String title = this.communityService.getMetadataFirstValue(community, CommunityService.MD_NAME, "*");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(community.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        doc.addField("dc.title_sort", (Object)title);
        return doc;
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof Community;
    }

    @Override
    public List getIndexableObjects(Context context, Community object) {
        return Arrays.asList(new IndexableCommunity(object));
    }

    @Override
    public Optional<IndexableCommunity> findIndexableObject(Context context, String id) throws SQLException {
        Community community = (Community)this.communityService.find(context, UUID.fromString(id));
        return community == null ? Optional.empty() : Optional.of(new IndexableCommunity(community));
    }

    @Override
    public List<String> getLocations(Context context, IndexableCommunity indexableDSpaceObject) throws SQLException {
        Community target = (Community)indexableDSpaceObject.getIndexedObject();
        ArrayList<String> locations = new ArrayList<String>();
        List<Community> communities = target.getParentCommunities();
        for (Community community : communities) {
            locations.add("m" + community.getID());
        }
        return locations;
    }
}

