/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external;

import eu.openaire.jaxb.helper.OpenAIREHandler;
import eu.openaire.jaxb.model.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.external.OpenAIRERestToken;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenAIRERestConnector {
    private static Logger log = LogManager.getLogger(OpenAIRERestConnector.class);
    private String url = "https://api.openaire.eu";
    boolean tokenEnabled = false;
    private String tokenServiceUrl;
    private String clientId;
    private OpenAIRERestToken accessToken;
    private String clientSecret;

    public OpenAIRERestConnector(String url) {
        this.url = url;
    }

    public OpenAIRERestToken grabNewAccessToken() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.tokenServiceUrl) || StringUtils.isBlank((CharSequence)this.clientId) || StringUtils.isBlank((CharSequence)this.clientSecret)) {
            throw new IOException("Cannot grab OpenAIRE token with nulls service url, client id or secret");
        }
        String auth = this.clientId + ":" + this.clientSecret;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + new String(encodedAuth);
        HttpPost httpPost = new HttpPost(this.tokenServiceUrl);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("User-Agent", "DSpace/" + Util.getSourceVersion());
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("Authorization", authHeader);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(1);
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse getResponse = httpClient.execute((HttpUriRequest)httpPost);
        JSONObject responseObject = null;
        try (InputStream is = getResponse.getEntity().getContent();
             BufferedReader streamReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String inputStr;
            while ((inputStr = streamReader.readLine()) != null && responseObject == null) {
                if (!inputStr.startsWith("{") || !inputStr.endsWith("}") || !inputStr.contains("access_token") || !inputStr.contains("expires_in")) continue;
                try {
                    responseObject = new JSONObject(inputStr);
                }
                catch (Exception e) {
                    responseObject = null;
                }
            }
        }
        if (responseObject == null || !responseObject.has("access_token") || !responseObject.has("expires_in")) {
            throw new IOException("Unable to grab the access token using provided service url, client id and secret");
        }
        return new OpenAIRERestToken(responseObject.get("access_token").toString(), Long.valueOf(responseObject.get("expires_in").toString()));
    }

    public InputStream get(String file, String accessToken) {
        HttpResponse getResponse = null;
        InputStream result = null;
        file = OpenAIRERestConnector.trimSlashes(file);
        try {
            URL fullPath = new URL(this.url + "/" + file);
            log.debug("Requesting: " + fullPath.toString());
            HttpGet httpGet = new HttpGet(fullPath.toURI());
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            getResponse = httpClient.execute((HttpUriRequest)httpGet);
            StatusLine status = getResponse.getStatusLine();
            switch (status.getStatusCode()) {
                case 403: 
                case 404: 
                case 429: {
                    Header[] limitUsed = getResponse.getHeaders("x-ratelimit-used");
                    Header[] limitMax = getResponse.getHeaders("x-ratelimit-limit");
                    if (limitUsed.length > 0) {
                        String limitMsg = limitUsed[0].getValue();
                        if (limitMax.length > 0) {
                            limitMsg = limitMsg.concat(" of " + limitMax[0].getValue());
                        }
                        this.getGotError((Exception)new NoHttpResponseException(status.getReasonPhrase() + " with usage limit " + limitMsg), this.url + "/" + file);
                        break;
                    }
                    this.getGotError((Exception)new NoHttpResponseException(status.getReasonPhrase()), this.url + "/" + file);
                    break;
                }
            }
            result = getResponse.getEntity().getContent();
        }
        catch (MalformedURLException e1) {
            this.getGotError(e1, this.url + "/" + file);
        }
        catch (Exception e) {
            this.getGotError(e, this.url + "/" + file);
        }
        return result;
    }

    public Response searchProjectByKeywords(int page, int size, String ... keywords) {
        String path = "search/projects?keywords=" + String.join((CharSequence)"+", keywords);
        return this.search(path, page, size);
    }

    public Response searchProjectByIDAndFunder(String projectID, String projectFunder, int page, int size) {
        String path = "search/projects?grantID=" + projectID + "&funder=" + projectFunder;
        return this.search(path, page, size);
    }

    public Response search(String path, int page, int size) {
        CharSequence[] queryStringPagination = new String[]{"page=" + page, "size=" + size};
        String queryString = path + (path.indexOf("?") > 0 ? "&" : "?") + String.join((CharSequence)"&", queryStringPagination);
        InputStream result = null;
        if (this.tokenEnabled) {
            try {
                if (this.accessToken == null) {
                    this.accessToken = this.grabNewAccessToken();
                } else if (!this.accessToken.isValidToken()) {
                    this.accessToken = this.grabNewAccessToken();
                }
                result = this.get(queryString, this.accessToken.getToken());
            }
            catch (IOException e) {
                log.error("Error grabbing the token: " + e.getMessage());
                this.getGotError(e, path);
            }
        } else {
            result = this.get(queryString, null);
        }
        if (result != null) {
            try {
                return OpenAIREHandler.unmarshal((InputStream)result);
            }
            catch (JAXBException e) {
                log.error("Error extracting result from request: " + queryString);
                this.getGotError((Exception)((Object)e), path);
            }
        }
        return null;
    }

    public static String trimSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    @Autowired(required=false)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Autowired(required=false)
    public void setTokenServiceUrl(String tokenServiceUrl) {
        this.tokenServiceUrl = tokenServiceUrl;
    }

    @Autowired(required=false)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Autowired(required=false)
    public void setTokenEnabled(boolean tokenEnabled) {
        this.tokenEnabled = tokenEnabled;
    }

    protected void getGotError(Exception e, String fullPath) {
        log.error("Error in rest connector for path: " + fullPath, (Throwable)e);
    }
}

