/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkaccesscontrol;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.matcher.ResourcePolicyMatcher;
import org.dspace.app.mediafilter.FormatFilter;
import org.dspace.app.mediafilter.factory.MediaFilterServiceFactory;
import org.dspace.app.mediafilter.service.MediaFilterService;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jdom2.Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BulkAccessControlIT
extends AbstractIntegrationTestWithDatabase {
    private static final String MEDIA_FILTER_PLUGINS_KEY = "filter.plugins";
    private static final String FILTER_PREFIX = "filter";
    private static final String INPUT_FORMATS_SUFFIX = "inputFormats";
    private Path tempDir;
    private String tempFilePath;
    private GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private SearchService searchService = SearchUtils.getSearchService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tempDir = Files.createTempDirectory("bulkAccessTest", new FileAttribute[0]);
        this.tempFilePath = this.tempDir + "/bulk-access.json";
    }

    @Override
    @After
    public void destroy() throws Exception {
        PathUtils.deleteDirectory((Path)this.tempDir);
        super.destroy();
    }

    @Test
    public void performBulkAccessWithAnonymousEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"An eperson to do the the Bulk Access Control must be specified")));
    }

    @Test
    public void performBulkAccessWithNotExistingEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String randomUUID = UUID.randomUUID().toString();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", randomUUID};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("EPerson cannot be found: " + randomUUID))));
    }

    @Test
    public void performBulkAccessWithNotAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Current user is not eligible to execute script bulk-access-control")));
    }

    @Test
    public void performBulkAccessWithCommunityAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").withAdminGroup(this.eperson).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", community.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void performBulkAccessWithCollectionAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").withAdminGroup(this.eperson).build();
        ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", collection.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void performBulkAccessWithItemAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).withAdminUser(this.eperson).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void performBulkAccessWithNotCollectionAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, community).withName("collection").withAdminGroup(this.eperson).build();
        Collection collectionTwo = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        ItemBuilder.createItem(this.context, collectionOne).build();
        ItemBuilder.createItem(this.context, collectionTwo).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", collectionOne.getID().toString(), "-u", collectionTwo.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Current user is not eligible to execute script bulk-access-control")));
    }

    @Test
    public void performBulkAccessWithNotCommunityAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community communityOne = CommunityBuilder.createCommunity(this.context).withName("community").withAdminGroup(this.eperson).build();
        Community communityTwo = CommunityBuilder.createCommunity(this.context).withName("community").build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", communityOne.getID().toString(), "-u", communityTwo.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Current user is not eligible to execute script bulk-access-control")));
    }

    @Test
    public void performBulkAccessWithNotItemAdminEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item itemOne = ItemBuilder.createItem(this.context, collection).withAdminUser(this.eperson).build();
        Item itemTwo = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", itemOne.getID().toString(), "-u", itemTwo.getID().toString(), "-f", this.tempFilePath, "-e", this.eperson.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Current user is not eligible to execute script bulk-access-control")));
    }

    @Test
    public void performBulkAccessWithoutRequiredParamTest() throws Exception {
        this.buildJsonFile("");
        String[] args = new String[]{"bulk-access-control", "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"A target uuid must be provided with at least on uuid")));
    }

    @Test
    public void performBulkAccessWithEmptyJsonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).withTitle("title").build();
        this.context.restoreAuthSystemState();
        this.buildJsonFile("");
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Error parsing json file")));
    }

    @Test
    public void performBulkAccessWithWrongModeOfItemValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"wrong\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"wrong value for item mode<wrong>")));
    }

    @Test
    public void performBulkAccessWithMissingModeOfItemValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"item mode node must be provided")));
    }

    @Test
    public void performBulkAccessWithWrongModeOfBitstreamValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"bitstream\": {\n      \"mode\": \"wrong\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"wrong value for bitstream mode<wrong>")));
    }

    @Test
    public void performBulkAccessWithMissingModeOfBitstreamValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"bitstream\": {\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"bitstream mode node must be provided")));
    }

    @Test
    public void performBulkAccessWithNotFoundAccessConditionNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"wrongAccess\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"wrong access condition <wrongAccess>")));
    }

    @Test
    public void performBulkAccessWithInvalidEmbargoAccessConditionDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"endDate\": \"2024-06-24T00:00:00Z\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"invalid access condition, The access condition embargo requires a start date.")));
    }

    @Test
    public void performBulkAccessWithInvalidLeaseAccessConditionDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String json = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"lease\",\n            \"startDate\": \"2024-06-24T00:00:00Z\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(json);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"invalid access condition, The access condition lease requires an end date.")));
    }

    @Test
    public void performBulkAccessForCommunityItemsWithBitstreamConstraintsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community communityOne = CommunityBuilder.createCommunity(this.context).withName("community one").build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"bitstream\": {\n      \"constraints\": {\n          \"uuid\": [\"" + UUID.randomUUID() + "\"]\n      },\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", communityOne.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"constraint is not supported when uuid isn't an Item")));
    }

    @Test
    public void performBulkAccessForMultipleItemsWithBitstreamConstraintsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community communityOne = CommunityBuilder.createCommunity(this.context).withName("community one").build();
        Community communityTwo = CommunityBuilder.createCommunity(this.context).withName("community two").build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"bitstream\": {\n      \"constraints\": {\n          \"uuid\": [\"" + UUID.randomUUID() + "\"]\n      },\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", communityOne.getID().toString(), "-u", communityTwo.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"constraint isn't supported when multiple uuids are provided")));
    }

    @Test
    public void performBulkAccessForSingleItemWithBitstreamConstraintsTest() throws Exception {
        Bitstream bitstreamTwo;
        Bitstream bitstreamOne;
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("community one").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection").build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        Bundle bundle = BundleBuilder.createBundle(this.context, item).withName("ORIGINAL").build();
        String bitstreamOneContent = "Dummy content one";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamOneContent, (String)CharEncoding.UTF_8);){
            bitstreamOne = BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bistream one").build();
        }
        String bitstreamTwoContent = "Dummy content of bitstream two";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamTwoContent, (String)CharEncoding.UTF_8);){
            bitstreamTwo = BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bistream two").build();
        }
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"bitstream\": {\n      \"constraints\": {\n          \"uuid\": [\"" + bitstreamOne.getID().toString() + "\"]\n      },\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("Replacing Bitstream {" + bitstreamOne.getID() + "} policy to access conditions:{embargo, start_date=2024-06-24}"))));
        bitstreamOne = (Bitstream)this.context.reloadEntity((ReloadableEntity)bitstreamOne);
        bitstreamTwo = (Bitstream)this.context.reloadEntity((ReloadableEntity)bitstreamTwo);
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        MatcherAssert.assertThat((Object)bitstreamOne.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bitstreamOne.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)));
        MatcherAssert.assertThat((Object)bitstreamTwo.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bitstreamTwo.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED)));
    }

    @Test
    public void performBulkAccessWithAddModeAndEmptyAccessConditionsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"add\"\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", parentCommunity.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"accessConditions of item must be provided with mode<add>")));
    }

    @Test
    public void performBulkAccessWithValidJsonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunityOne = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Community subCommunityTwo = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community two").build();
        Community subCommunityThree = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community three").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, subCommunityOne).withName("collection one").build();
        Collection collectionTwo = CollectionBuilder.createCollection(this.context, subCommunityTwo).withName("collection two").build();
        Collection collectionThree = CollectionBuilder.createCollection(this.context, subCommunityThree).withName("collection three").build();
        Item itemOne = ItemBuilder.createItem(this.context, collectionOne).build();
        Item itemTwo = ItemBuilder.createItem(this.context, collectionTwo).build();
        Item itemThree = ItemBuilder.createItem(this.context, collectionThree).withTitle("item three title").build();
        Item itemFour = ItemBuilder.createItem(this.context, collectionThree).withTitle("item four title").build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunityOne.getID().toString(), "-u", collectionTwo.getID().toString(), "-u", itemThree.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.containsString((String)("Replacing Item {" + itemOne.getID() + "} policy to access conditions:{embargo, start_date=2024-06-24}")), Matchers.containsString((String)("Replacing Item {" + itemTwo.getID() + "} policy to access conditions:{embargo, start_date=2024-06-24}")), Matchers.containsString((String)("Replacing Item {" + itemThree.getID() + "} policy to access conditions:{embargo, start_date=2024-06-24}"))}));
        itemOne = (Item)this.context.reloadEntity((ReloadableEntity)itemOne);
        itemTwo = (Item)this.context.reloadEntity((ReloadableEntity)itemTwo);
        itemThree = (Item)this.context.reloadEntity((ReloadableEntity)itemThree);
        itemFour = (Item)this.context.reloadEntity((ReloadableEntity)itemFour);
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        MatcherAssert.assertThat((Object)itemOne.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)itemOne.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)));
        MatcherAssert.assertThat((Object)itemTwo.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)itemTwo.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)));
        MatcherAssert.assertThat((Object)itemThree.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)itemThree.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)));
        MatcherAssert.assertThat((Object)itemFour.getResourcePolicies().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)itemFour.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED)));
    }

    @Test
    public void performBulkAccessWithReplaceModeAndEmptyAccessConditionsTest() throws Exception {
        int i;
        this.context.turnOffAuthorisationSystem();
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunityOne = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Community subCommunityTwo = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community two").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, subCommunityOne).withName("collection one").build();
        Collection collectionTwo = CollectionBuilder.createCollection(this.context, subCommunityTwo).withName("collection two").build();
        for (i = 0; i < 20; ++i) {
            ItemBuilder.createItem(this.context, collectionOne).build();
        }
        for (i = 0; i < 5; ++i) {
            Item item2 = ItemBuilder.createItem(this.context, collectionTwo).build();
            Bundle bundle = BundleBuilder.createBundle(this.context, item2).withName("ORIGINAL").build();
            String bitstreamContent = "Dummy content";
            try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
                BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bistream").build();
                continue;
            }
        }
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"replace\"\n   },\n \"bitstream\": {\n      \"mode\": \"replace\"\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunityOne.getID().toString(), "-u", collectionTwo.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)60));
        List<Item> itemsOfSubCommOne = this.findItems("location.comm:" + subCommunityOne.getID());
        List<Item> itemsOfSubCommTwo = this.findItems("location.comm:" + subCommunityTwo.getID());
        MatcherAssert.assertThat(itemsOfSubCommOne, (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat(itemsOfSubCommTwo, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)itemsOfSubCommOne.stream().flatMap(item -> this.findAllBitstreams((Item)item).stream()).count(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)itemsOfSubCommTwo.stream().flatMap(item -> this.findAllBitstreams((Item)item).stream()).count(), (Matcher)Matchers.is((Object)5L));
        for (Item item3 : itemsOfSubCommOne) {
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED)));
        }
        for (Item item3 : itemsOfSubCommTwo) {
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED)));
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.containsString((String)("Cleaning Item {" + item3.getID() + "} policies")), Matchers.containsString((String)("Inheriting policies from owning Collection in Item {" + item3.getID()))}));
            List<Bitstream> bitstreams = this.findAllBitstreams(item3);
            for (Bitstream bitstream : bitstreams) {
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED)));
                MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.containsString((String)("Cleaning Bitstream {" + bitstream.getID() + "} policies")), Matchers.containsString((String)("Inheriting policies from owning Collection in Bitstream {" + bitstream.getID()))}));
            }
        }
    }

    @Test
    public void performBulkAccessWithAddModeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunityOne = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, subCommunityOne).withName("collection one").build();
        for (int i = 0; i < 5; ++i) {
            Item item2 = ItemBuilder.createItem(this.context, collectionOne).build();
            Bundle bundle = BundleBuilder.createBundle(this.context, item2).withName("ORIGINAL").build();
            String bitstreamContent = "Dummy content";
            try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
                BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bistream").build();
                continue;
            }
        }
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   },\n \"bitstream\": {\n      \"mode\": \"add\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"lease\",\n            \"endDate\": \"2023-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunityOne.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)10));
        List<Item> itemsOfSubCommOne = this.findItems("location.comm:" + subCommunityOne.getID());
        MatcherAssert.assertThat(itemsOfSubCommOne, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)itemsOfSubCommOne.stream().flatMap(item -> this.findAllBitstreams((Item)item).stream()).count(), (Matcher)Matchers.is((Object)5L));
        for (Item item3 : itemsOfSubCommOne) {
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasSize((int)3));
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED), ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)}));
            List<Bitstream> bitstreams = this.findAllBitstreams(item3);
            for (Bitstream bitstream : bitstreams) {
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.hasSize((int)3));
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, ResourcePolicy.TYPE_INHERITED), ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "lease", ResourcePolicy.TYPE_CUSTOM, null, "2023-06-24", null)}));
            }
        }
    }

    @Test
    public void performBulkAccessWithReplaceModeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunityOne = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, subCommunityOne).withName("collection one").build();
        for (int i = 0; i < 3; ++i) {
            Item item2 = ItemBuilder.createItem(this.context, collectionOne).build();
            Bundle bundle = BundleBuilder.createBundle(this.context, item2).withName("ORIGINAL").build();
            String bitstreamContent = "Dummy content";
            try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
                BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bistream").build();
                continue;
            }
        }
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   },\n \"bitstream\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"lease\",\n            \"endDate\": \"2023-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunityOne.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)6));
        List<Item> itemsOfSubCommOne = this.findItems("location.comm:" + subCommunityOne.getID());
        MatcherAssert.assertThat(itemsOfSubCommOne, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)itemsOfSubCommOne.stream().flatMap(item -> this.findAllBitstreams((Item)item).stream()).count(), (Matcher)Matchers.is((Object)3L));
        for (Item item3 : itemsOfSubCommOne) {
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat((Object)item3.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)}));
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("Replacing Item {" + item3.getID() + "} policy to access conditions:{openaccess, embargo, start_date=2024-06-24}"))));
            List<Bitstream> bitstreams = this.findAllBitstreams(item3);
            for (Bitstream bitstream : bitstreams) {
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
                MatcherAssert.assertThat((Object)bitstream.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "lease", ResourcePolicy.TYPE_CUSTOM, null, "2023-06-24", null)}));
                MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("Replacing Bitstream {" + bitstream.getID() + "} policy to access conditions:{openaccess, lease, end_date=2023-06-24}"))));
            }
        }
    }

    @Test
    public void performBulkAccessAndCheckDerivativeBitstreamsPoliciesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunityOne = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Collection collectionOne = CollectionBuilder.createCollection(this.context, subCommunityOne).withName("collection one").build();
        Item item = ItemBuilder.createItem(this.context, collectionOne).build();
        Bundle bundle = BundleBuilder.createBundle(this.context, item).withName("ORIGINAL").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            BitstreamBuilder.createBitstream(this.context, bundle, is).withName("bitstream").withFormat("TEXT").withMimeType("text/plain").build();
        }
        ArrayList<FormatFilter> formatFilters = new ArrayList<FormatFilter>();
        HashMap<CallSite, List<Object>> filterFormats = new HashMap<CallSite, List<Object>>();
        MediaFilterService mediaFilterService = MediaFilterServiceFactory.getInstance().getMediaFilterService();
        String[] filterNames = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty(MEDIA_FILTER_PLUGINS_KEY);
        for (int i = 0; i < filterNames.length; ++i) {
            Object[] formats;
            FormatFilter filter = (FormatFilter)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(FormatFilter.class, filterNames[i]);
            formatFilters.add(filter);
            String filterClassName = filter.getClass().getName();
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filter.getClass())) {
                pluginName = ((SelfNamedPlugin)filter).getPluginInstanceName();
            }
            if (!ArrayUtils.isNotEmpty((Object[])(formats = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("filter." + filterClassName + (String)(pluginName != null ? "." + pluginName : "") + ".inputFormats")))) continue;
            filterFormats.put((CallSite)((Object)(filterClassName + (String)(pluginName != null ? "\u001c" + pluginName : ""))), Arrays.asList(formats));
        }
        mediaFilterService.setFilterClasses(formatFilters);
        mediaFilterService.setFilterFormats(filterFormats);
        mediaFilterService.applyFiltersItem(this.context, item);
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   },\n \"bitstream\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          },\n          {\n            \"name\": \"lease\",\n            \"endDate\": \"2023-06-24\"\n          }\n      ]\n   }\n}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunityOne.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)2));
        item = (Item)this.context.reloadEntity((ReloadableEntity)item);
        Bundle originalBundle = (Bundle)item.getBundles("ORIGINAL").get(0);
        Bundle textBundle = (Bundle)item.getBundles("TEXT").get(0);
        MatcherAssert.assertThat((Object)item.getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)item.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null)}));
        MatcherAssert.assertThat((Object)((Bitstream)originalBundle.getBitstreams().get(0)).getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Bitstream)originalBundle.getBitstreams().get(0)).getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "lease", ResourcePolicy.TYPE_CUSTOM, null, "2023-06-24", null)}));
        MatcherAssert.assertThat((Object)((Bitstream)textBundle.getBitstreams().get(0)).getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Bitstream)textBundle.getBitstreams().get(0)).getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "openaccess", ResourcePolicy.TYPE_CUSTOM), ResourcePolicyMatcher.matches(0, anonymousGroup, "lease", ResourcePolicy.TYPE_CUSTOM, null, "2023-06-24", null)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void performBulkAccessWithReplaceModeAndAppendModeIsEnabledTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup(this.context).withName("special network").build();
        Community community = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withName("collection one").withDefaultItemRead(group).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String jsonOne = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"embargo\",\n            \"startDate\": \"2024-06-24\"\n          }\n      ]\n   }}\n";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", item.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        try {
            this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)true);
            TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
            ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.containsString((String)("Replacing Item {" + item.getID() + "} policy to access conditions:{embargo, start_date=2024-06-24}")), Matchers.containsString((String)("Inheriting policies from owning Collection in Item {" + item.getID() + "}"))}));
            item = (Item)this.context.reloadEntity((ReloadableEntity)item);
            Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
            MatcherAssert.assertThat((Object)item.getResourcePolicies(), (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat((Object)item.getResourcePolicies(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matches(0, anonymousGroup, "embargo", ResourcePolicy.TYPE_CUSTOM, "2024-06-24", null, null), ResourcePolicyMatcher.matches(0, group, ResourcePolicy.TYPE_INHERITED)}));
        }
        finally {
            this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)false);
        }
    }

    @Test
    public void performBulkAccessWithReplaceModeOnItemsWithMultipleBundlesTest() throws Exception {
        Bitstream bitstreamTwo;
        Bitstream bitstreamOne;
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity(this.context, parentCommunity).withName("sub community one").build();
        Collection collection = CollectionBuilder.createCollection(this.context, subCommunity).withName("collection one").build();
        Item itemOne = ItemBuilder.createItem(this.context, collection).build();
        Item itemTwo = ItemBuilder.createItem(this.context, collection).build();
        ItemBuilder.createItem(this.context, collection).build();
        Bundle bundleOne = BundleBuilder.createBundle(this.context, itemOne).withName("ORIGINAL").build();
        Bundle bundleTwo = BundleBuilder.createBundle(this.context, itemTwo).withName("ORIGINAL").build();
        BundleBuilder.createBundle(this.context, itemTwo).withName("ORIGINAL").build();
        BundleBuilder.createBundle(this.context, itemOne).withName("TEXT").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            bitstreamOne = BitstreamBuilder.createBitstream(this.context, bundleOne, is).withName("bistream of bundle one").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);
        try {
            bitstreamTwo = BitstreamBuilder.createBitstream(this.context, bundleTwo, is).withName("bitstream of bundle two").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        String jsonOne = "{\n  \"bitstream\": {\n    \"constraints\": {\n      \"uuid\": []\n    },\n    \"mode\": \"replace\",\n    \"accessConditions\": [\n      {\n        \"name\": \"administrator\",\n        \"startDate\": null,\n        \"endDate\": null\n      }\n    ]\n  }\n}";
        this.buildJsonFile(jsonOne);
        String[] args = new String[]{"bulk-access-control", "-u", subCommunity.getID().toString(), "-f", this.tempFilePath, "-e", this.admin.getEmail()};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.containsString((String)("Replacing Bitstream {" + bitstreamOne.getID() + "} policy to access conditions:{administrator}")), Matchers.containsString((String)("Replacing Bitstream {" + bitstreamTwo.getID() + "} policy to access conditions:{administrator}"))}));
        bitstreamOne = (Bitstream)this.context.reloadEntity((ReloadableEntity)bitstreamOne);
        bitstreamTwo = (Bitstream)this.context.reloadEntity((ReloadableEntity)bitstreamTwo);
        MatcherAssert.assertThat((Object)bitstreamOne.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bitstreamOne.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, adminGroup, "administrator", ResourcePolicy.TYPE_CUSTOM)));
        MatcherAssert.assertThat((Object)bitstreamTwo.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bitstreamTwo.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches(0, adminGroup, "administrator", ResourcePolicy.TYPE_CUSTOM)));
    }

    @Test
    public void performBulkAccessWithHelpParamTest() throws Exception {
        String[] args = new String[]{"bulk-access-control", "-h"};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
    }

    private List<Item> findItems(String query) throws SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableItem.TYPE);
        discoverQuery.setQuery(query);
        return this.searchService.search(this.context, discoverQuery).getIndexableObjects().stream().map(indexableObject -> (Item)((IndexableItem)indexableObject).getIndexedObject()).collect(Collectors.toList());
    }

    private List<Bitstream> findAllBitstreams(Item item) {
        return item.getBundles("ORIGINAL").stream().flatMap(bundle -> bundle.getBitstreams().stream()).collect(Collectors.toList());
    }

    private void buildJsonFile(String json) throws IOException {
        File file = new File(this.tempDir + "/bulk-access.json");
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

