/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.util.List;
import org.dspace.app.requestitem.CollectionAdministratorsRequestItemStrategy;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CollectionAdministratorsRequestItemStrategyTest {
    private static final String NAME = "John Q. Public";
    private static final String EMAIL = "jqpublic@example.com";

    @Test
    public void testGetRequestItemAuthor() throws Exception {
        System.out.println("getRequestItemAuthor");
        Context context = (Context)Mockito.mock(Context.class);
        EPerson eperson1 = (EPerson)Mockito.mock(EPerson.class);
        Mockito.when((Object)eperson1.getEmail()).thenReturn((Object)EMAIL);
        Mockito.when((Object)eperson1.getFullName()).thenReturn((Object)NAME);
        Group group1 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group1.getMembers()).thenReturn(List.of(eperson1));
        Collection collection1 = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)collection1.getAdministrators()).thenReturn((Object)group1);
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getOwningCollection()).thenReturn((Object)collection1);
        Mockito.when((Object)item.getSubmitter()).thenReturn((Object)eperson1);
        CollectionAdministratorsRequestItemStrategy instance = new CollectionAdministratorsRequestItemStrategy();
        List result = instance.getRequestItemAuthor(context, item);
        Assert.assertEquals((String)"Should be one author", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Name should match John Q. Public", (Object)NAME, (Object)((RequestItemAuthor)result.get(0)).getFullName());
        Assert.assertEquals((String)"Email should match jqpublic@example.com", (Object)EMAIL, (Object)((RequestItemAuthor)result.get(0)).getEmail());
    }
}

