/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.google.common.base.Splitter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.GoogleMetadata;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GoogleMetadataTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(GoogleMetadataTest.class);
    private Item it;
    private BundleService bundleService;
    private BitstreamFormatService bitstreamFormatService;
    private BitstreamService bitstreamService;
    private ResourcePolicyService resourcePolicyService;
    private GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private Community community;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = ContentServiceFactory.getInstance().getCommunityService().create(null, this.context);
            Collection collection = ContentServiceFactory.getInstance().getCollectionService().create(this.context, this.community);
            WorkspaceItem wi = ContentServiceFactory.getInstance().getWorkspaceItemService().create(this.context, collection, true);
            Item item = wi.getItem();
            ContentServiceFactory.getInstance().getInstallItemService().installItem(this.context, (InProgressSubmission)wi, null);
            this.context.restoreAuthSystemState();
            this.context.commit();
            this.it = item;
            this.bundleService = ContentServiceFactory.getInstance().getBundleService();
            this.bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
            this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
            this.resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
            this.groupService = EPersonServiceFactory.getInstance().getGroupService();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (IOException e) {
            log.error("IO Error in init", (Throwable)e);
            Assert.fail((String)("IO Error in init: " + e.getMessage()));
        }
    }

    @Test
    public void testGetPDFURLDifferentMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 1".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "Word");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/msword");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 2".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "Pdf");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 3".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "Rtf");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("text/richtext");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"Pdf", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPDFURLSameMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("123456789".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "size9");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "size1");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12345".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "size5");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("text/richtext");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"size9", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPDFURLSameMimeTypesSameSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "first");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "second");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "third");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"first", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPDFURLWithPrimaryBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Larger file than primary".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "first");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream with more prioritized mimetype than primary".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "second");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "primary");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("Primary");
        this.bundleService.addBitstream(this.context, bundle, b3);
        bundle.setPrimaryBitstreamID(b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"primary", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPDFURLWithUndefinedMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "small");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown type 1");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12121212".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "medium");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("unknown type 2");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12121212121212".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "large");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("unknown type 3");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"large", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPDFURLWithNoBundle() throws Exception {
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        Assert.assertEquals((long)0L, (long)gm.getPDFURL().size());
    }

    @Test
    public void testGetPDFURLWithNoBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        Assert.assertEquals((long)0L, (long)gm.getPDFURL().size());
    }

    @Test
    public void testGetPDFURLWithEmptyBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "small");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown type 1");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)));
        b2.setName(this.context, "medium");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("unknown type 2");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)));
        b3.setName(this.context, "large");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("unknown type 3");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        List urlSplitted = Splitter.on((String)"/").splitToList((CharSequence)gm.getPDFURL().get(0));
        Assert.assertEquals((Object)"small", urlSplitted.get(urlSplitted.size() - 1));
    }

    @Test
    public void testGetPdfUrlOfEmbargoed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Larger file than primary".getBytes(StandardCharsets.UTF_8)));
        b.setName(this.context, "first");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown");
        this.bundleService.addBitstream(this.context, bundle, b);
        MutablePeriod period = PeriodFormat.getDefault().parseMutablePeriod("3 months");
        Date embargoDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).plus((ReadablePeriod)period).toDate();
        Group anonGroup = this.groupService.findByName(this.context, "Anonymous");
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)b);
        this.resourcePolicyService.removeAllPolicies(this.context, (DSpaceObject)b);
        ResourcePolicy rp = this.authorizeService.createOrModifyPolicy(null, this.context, null, anonGroup, null, embargoDate, 0, "GoogleMetadataTest", (DSpaceObject)b);
        if (rp != null) {
            this.resourcePolicyService.update(this.context, rp);
        }
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        Assert.assertTrue((boolean)gm.getPDFURL().isEmpty());
        boolean containsPdfUrl = false;
        for (Map.Entry mapping : gm.getMappings()) {
            String string = (String)mapping.getKey();
            Objects.requireNonNull(gm);
            if (!string.equalsIgnoreCase("citation_pdf_url")) continue;
            containsPdfUrl = true;
        }
        Assert.assertFalse((boolean)containsPdfUrl);
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = (Community)this.context.reloadEntity((ReloadableEntity)this.community);
            ContentServiceFactory.getInstance().getCommunityService().delete(this.context, (DSpaceObject)this.community);
            this.community = null;
        }
        catch (Exception e) {
            throw new AssertionError("Error occurred in destroy()", e);
        }
        this.it = null;
        super.destroy();
    }
}

