/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.junit.Assert;
import org.junit.Test;

public class SubmissionConfigIT
extends AbstractIntegrationTestWithDatabase {
    @Test
    public void testSubmissionConfigMapByCollectionOrEntityType() throws SubmissionConfigReaderException {
        this.context.turnOffAuthorisationSystem();
        Community topcom = CommunityBuilder.createCommunity(this.context, "123456789/topcommunity-test").withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, topcom, "123456789/collection-test").withName("Collection 1").withEntityType("CustomEntityType").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, topcom, "123456789/not-mapped1").withName("Collection 2").withEntityType("CustomEntityType").build();
        this.context.restoreAuthSystemState();
        SubmissionConfigService submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
        SubmissionConfig submissionConfig1 = submissionConfigService.getSubmissionConfigByCollection(col1);
        Assert.assertEquals((Object)"collectiontest", (Object)submissionConfig1.getSubmissionName());
        SubmissionConfig submissionConfig2 = submissionConfigService.getSubmissionConfigByCollection(col2);
        Assert.assertEquals((Object)"entitytypetest", (Object)submissionConfig2.getSubmissionName());
    }
}

