/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;

public class BundleBuilder
extends AbstractDSpaceObjectBuilder<Bundle> {
    private Bundle bundle;
    private Item item;
    private String name;
    private final List<Bitstream> bitstreams = new ArrayList<Bitstream>();

    protected BundleBuilder(Context context) {
        super(context);
    }

    public static BundleBuilder createBundle(Context context, Item item) {
        BundleBuilder builder = new BundleBuilder(context);
        return builder.create(context, item);
    }

    private BundleBuilder create(Context context, Item item) {
        this.context = context;
        this.item = item;
        return this;
    }

    public BundleBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public BundleBuilder withBitstream(Bitstream bitstream) {
        this.bitstreams.add(bitstream);
        return this;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.bundle = (Bundle)c.reloadEntity((ReloadableEntity)this.bundle);
            if (this.bundle != null) {
                this.delete(c, this.bundle);
                c.complete();
            }
        }
    }

    @Override
    protected DSpaceObjectService<Bundle> getService() {
        return bundleService;
    }

    @Override
    public Bundle build() throws SQLException, AuthorizeException {
        this.bundle = bundleService.create(this.context, this.item, this.name);
        for (Bitstream bitstream : this.bitstreams) {
            bundleService.addBitstream(this.context, this.bundle, bitstream);
        }
        return this.bundle;
    }

    public static void deleteBundle(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Bundle bundle = (Bundle)bundleService.find(c, uuid);
            if (bundle != null) {
                try {
                    bundleService.delete(c, (DSpaceObject)bundle);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }
}

