/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.service.OrcidTokenService;

public class OrcidTokenBuilder
extends AbstractBuilder<OrcidToken, OrcidTokenService> {
    private OrcidToken orcidToken;

    protected OrcidTokenBuilder(Context context) {
        super(context);
    }

    public static OrcidTokenBuilder create(Context context, EPerson ePerson, String accessToken) {
        OrcidTokenBuilder builder = new OrcidTokenBuilder(context);
        builder.create(ePerson, accessToken);
        return builder;
    }

    private void create(EPerson ePerson, String accessToken) {
        this.orcidToken = orcidTokenService.create(this.context, ePerson, accessToken);
    }

    public OrcidTokenBuilder withProfileItem(Item profileItem) {
        this.orcidToken.setProfileItem(profileItem);
        return this;
    }

    @Override
    public OrcidToken build() throws SQLException, AuthorizeException {
        return this.orcidToken;
    }

    @Override
    public void delete(Context c, OrcidToken orcidToken) throws Exception {
        orcidTokenService.delete(c, orcidToken);
    }

    @Override
    public void cleanup() throws Exception {
        try (Context context = new Context();){
            context.setDispatcher("noindex");
            context.turnOffAuthorisationSystem();
            this.orcidToken = (OrcidToken)context.reloadEntity((ReloadableEntity)this.orcidToken);
            if (this.orcidToken != null) {
                this.delete(context, this.orcidToken);
                context.complete();
            }
        }
    }

    @Override
    protected OrcidTokenService getService() {
        return orcidTokenService;
    }
}

