/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.ctask.general.CreateMissingIdentifiers;
import org.dspace.curate.Curator;
import org.dspace.identifier.AbstractIdentifierProviderIT;
import org.dspace.identifier.VersionedHandleIdentifierProvider;
import org.dspace.identifier.VersionedHandleIdentifierProviderWithCanonicalHandles;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Test;

public class CreateMissingIdentifiersIT
extends AbstractIdentifierProviderIT {
    private static final String P_TASK_DEF = "plugin.named.org.dspace.curate.CurationTask";
    private static final String TASK_NAME = "test";
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Test
    public void testPerform() throws IOException {
        CoreServiceFactory.getInstance().getPluginService().clearNamedPluginClasses();
        this.configurationService.setProperty(P_TASK_DEF, (Object)(CreateMissingIdentifiers.class.getCanonicalName() + " = test"));
        Curator curator = new Curator();
        curator.addTask(TASK_NAME);
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.registerProvider(VersionedHandleIdentifierProviderWithCanonicalHandles.class);
        curator.curate(this.context, (DSpaceObject)item);
        System.out.format("With incompatible provider, result is '%s'.\n", curator.getResult(TASK_NAME));
        Assert.assertEquals((String)"Curation should fail", (long)-1L, (long)curator.getStatus(TASK_NAME));
        this.unregisterProvider(VersionedHandleIdentifierProviderWithCanonicalHandles.class);
        this.registerProvider(VersionedHandleIdentifierProvider.class);
        curator.curate(this.context, (DSpaceObject)item);
        int status = curator.getStatus(TASK_NAME);
        Assert.assertEquals((String)"Curation should succeed", (long)0L, (long)status);
    }
}

