/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service;

import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.orcid.service.MetadataSignatureGenerator;
import org.dspace.orcid.service.impl.PlainMetadataSignatureGeneratorImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class PlainMetadataSignatureGeneratorIT
extends AbstractIntegrationTestWithDatabase {
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private Collection collection;
    private MetadataSignatureGenerator generator = new PlainMetadataSignatureGeneratorImpl();

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withTitle("Parent community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testSignatureGenerationWithManyMetadataValues() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Item title").withIssueDate("2020-01-01").withAuthor("Jesse Pinkman").withEditor("Editor").build();
        this.context.restoreAuthSystemState();
        MetadataValue author = this.getMetadata(item, "dc.contributor.author", 0);
        MetadataValue editor = this.getMetadata(item, "dc.contributor.editor", 0);
        String signature = this.generator.generate(this.context, List.of(author, editor));
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.notNullValue());
        String expectedSignature = "dc.contributor.author::Jesse Pinkman\u00a7\u00a7dc.contributor.editor::Editor";
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)expectedSignature));
        String anotherSignature = this.generator.generate(this.context, List.of(editor, author));
        MatcherAssert.assertThat((Object)anotherSignature, (Matcher)Matchers.equalTo((Object)signature));
        List metadataValues = this.generator.findBySignature(this.context, item, signature);
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.containsInAnyOrder((Object[])new MetadataValue[]{author, editor}));
    }

    @Test
    public void testSignatureGenerationWithSingleMetadataValue() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Item title").withDescription("Description").withAuthor("Jesse Pinkman").withUriIdentifier("https://www.4science.it/en").build();
        this.context.restoreAuthSystemState();
        MetadataValue description = this.getMetadata(item, "dc.description", 0);
        String signature = this.generator.generate(this.context, List.of(description));
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"dc.description::Description"));
        List metadataValues = this.generator.findBySignature(this.context, item, signature);
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.containsInAnyOrder((Object[])new MetadataValue[]{description}));
        MetadataValue url = this.getMetadata(item, "dc.identifier.uri", 0);
        signature = this.generator.generate(this.context, List.of(url));
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"dc.identifier.uri::https://www.4science.it/en"));
        metadataValues = this.generator.findBySignature(this.context, item, signature);
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.containsInAnyOrder((Object[])new MetadataValue[]{url}));
    }

    @Test
    public void testSignatureGenerationWithManyEqualsMetadataValues() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Item title").withDescription("Description").withAuthor("Jesse Pinkman").withAuthor("Jesse Pinkman").build();
        this.context.restoreAuthSystemState();
        MetadataValue firstAuthor = this.getMetadata(item, "dc.contributor.author", 0);
        String firstSignature = this.generator.generate(this.context, List.of(firstAuthor));
        MatcherAssert.assertThat((Object)firstSignature, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)firstSignature, (Matcher)Matchers.equalTo((Object)"dc.contributor.author::Jesse Pinkman"));
        MetadataValue secondAuthor = this.getMetadata(item, "dc.contributor.author", 1);
        String secondSignature = this.generator.generate(this.context, List.of(secondAuthor));
        MatcherAssert.assertThat((Object)secondSignature, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)secondSignature, (Matcher)Matchers.equalTo((Object)"dc.contributor.author::Jesse Pinkman"));
        List metadataValues = this.generator.findBySignature(this.context, item, firstSignature);
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)metadataValues, (Matcher)Matchers.anyOf((Matcher)Matchers.contains((Object[])new MetadataValue[]{firstAuthor}), (Matcher)Matchers.contains((Object[])new MetadataValue[]{secondAuthor})));
    }

    private MetadataValue getMetadata(Item item, String metadataField, int place) {
        List values = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataField);
        MatcherAssert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(place)));
        return (MetadataValue)values.get(place);
    }
}

