/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractDSpaceTest;
import org.dspace.core.Utils;
import org.dspace.service.ClientInfoService;
import org.dspace.service.impl.ClientInfoServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.util.DummyHttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ClientInfoServiceImplTest
extends AbstractDSpaceTest {
    private ClientInfoService clientInfoService;
    private ConfigurationService configurationService;

    @Before
    public void init() {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Test
    public void getClientIpFromRequest() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"1.2.3");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress("1.2.3.4");
        req.addHeader("X-Forwarded-For", "192.168.1.24");
        Assert.assertEquals((Object)"192.168.1.24", (Object)this.clientInfoService.getClientIp((HttpServletRequest)req));
    }

    @Test
    public void getClientIpWithTrustedProxy() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"1.2.3");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "1.2.3.4";
        String xForwardedFor = "192.168.1.24";
        Assert.assertEquals((Object)"192.168.1.24", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        Assert.assertEquals((Object)"192.168.1.24", (Object)this.clientInfoService.getClientIp("127.0.0.1", xForwardedFor));
    }

    @Test
    public void getClientIpWithUntrustedProxy() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"192.168.1.1");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "10.24.64.14";
        String xForwardedFor = "192.168.1.24";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithMultipleTrustedProxies() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"1.2.3,192.168.1");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "1.2.3.4";
        String xForwardedFor = "10.24.64.14, 192.168.1.24";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        xForwardedFor = "192.168.1.24, 10.24.64.14";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithoutTrustedProxiesAndTrustedUI() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"");
        this.configurationService.setProperty("proxies.trusted.include_ui_ip", (Object)true);
        String fakeUI_URL = "https://mydspace.edu/";
        String fakeUI_IP = "1.2.3.4";
        this.configurationService.setProperty("dspace.ui.url", (Object)fakeUI_URL);
        try (MockedStatic mockedUtils = Mockito.mockStatic(Utils.class);){
            mockedUtils.when(() -> Utils.getIPAddresses((String)fakeUI_URL)).thenReturn((Object)new String[]{fakeUI_IP});
            ClientInfoServiceImpl clientInfoServiceMock = new ClientInfoServiceImpl(this.configurationService);
            String xForwardedFor = "10.24.64.14";
            Assert.assertEquals((Object)"10.24.64.14", (Object)clientInfoServiceMock.getClientIp(fakeUI_IP, xForwardedFor));
            xForwardedFor = "1.2.3.4,10.24.64.14";
            Assert.assertEquals((Object)"10.24.64.14", (Object)clientInfoServiceMock.getClientIp(fakeUI_IP, xForwardedFor));
            xForwardedFor = "10.24.64.14,1.2.3.4";
            Assert.assertEquals((Object)"10.24.64.14", (Object)clientInfoServiceMock.getClientIp(fakeUI_IP, xForwardedFor));
            Assert.assertEquals((Object)"10.24.64.14", (Object)clientInfoServiceMock.getClientIp("127.0.0.1", xForwardedFor));
        }
    }

    @Test
    public void getClientIpWithoutTrustedProxiesAndUntrustedUI() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"");
        this.configurationService.setProperty("proxies.trusted.include_ui_ip", (Object)false);
        String fakeUI_URL = "https://mydspace.edu/";
        String fakeUI_IP = "1.2.3.4";
        this.configurationService.setProperty("dspace.ui.url", (Object)fakeUI_URL);
        try (MockedStatic mockedUtils = Mockito.mockStatic(Utils.class);){
            mockedUtils.when(() -> Utils.getIPAddresses((String)fakeUI_URL)).thenReturn((Object)new String[]{fakeUI_IP});
            ClientInfoServiceImpl clientInfoServiceMock = new ClientInfoServiceImpl(this.configurationService);
            String xForwardedFor = "10.24.64.14";
            Assert.assertEquals((Object)fakeUI_IP, (Object)clientInfoServiceMock.getClientIp(fakeUI_IP, xForwardedFor));
            Assert.assertEquals((Object)"10.24.64.14", (Object)clientInfoServiceMock.getClientIp("127.0.0.1", xForwardedFor));
        }
    }

    @Test
    public void getClientIpWithoutUseProxies() {
        this.configurationService.setProperty("useProxies", (Object)false);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "127.0.0.1";
        String xForwardedFor = "10.24.64.14";
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, null));
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, ""));
    }

    @Test
    public void isUseProxiesEnabledTrue() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        Assert.assertTrue((boolean)this.clientInfoService.isUseProxiesEnabled());
    }

    @Test
    public void isUseProxiesEnabledFalse() {
        this.configurationService.setProperty("useProxies", (Object)false);
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        Assert.assertFalse((boolean)this.clientInfoService.isUseProxiesEnabled());
    }

    @Test
    public void testIpAnonymization() {
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "192.168.1.25";
        Assert.assertEquals((Object)"192.168.1.25", (Object)this.clientInfoService.getClientIp(remoteIp, null));
        try {
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)1);
            Assert.assertEquals((Object)"192.168.1.0", (Object)this.clientInfoService.getClientIp(remoteIp, null));
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)2);
            Assert.assertEquals((Object)"192.168.0.0", (Object)this.clientInfoService.getClientIp(remoteIp, null));
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)3);
            Assert.assertEquals((Object)"192.0.0.0", (Object)this.clientInfoService.getClientIp(remoteIp, null));
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)4);
            Assert.assertEquals((Object)"0.0.0.0", (Object)this.clientInfoService.getClientIp(remoteIp, null));
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)5);
            Assert.assertEquals((Object)"192.168.1.25", (Object)this.clientInfoService.getClientIp(remoteIp, null));
        }
        finally {
            this.configurationService.setProperty("client.ip-anonymization.parts", (Object)0);
        }
    }
}

