/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sitemap.HTMLSitemapGenerator;
import org.dspace.app.sitemap.SitemapsOrgGenerator;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class GenerateSitemaps {
    private static final Logger log = LogManager.getLogger(GenerateSitemaps.class);
    private static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final SearchService searchService = SearchUtils.getSearchService();
    private static final int PAGE_SIZE = 100;

    private GenerateSitemaps() {
    }

    public static void main(String[] args) throws Exception {
        String usage = GenerateSitemaps.class.getCanonicalName();
        DefaultParser parser = new DefaultParser();
        HelpFormatter hf = new HelpFormatter();
        Options options = new Options();
        options.addOption("h", "help", false, "help");
        options.addOption("s", "no_sitemaps", false, "do not generate sitemaps.org protocol sitemap");
        options.addOption("b", "no_htmlmap", false, "do not generate a basic HTML sitemap");
        options.addOption("d", "delete", false, "delete sitemaps dir and its contents");
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            hf.printHelp(usage, options);
            System.exit(0);
        }
        if (line.getArgs().length != 0) {
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (line.getArgs().length != 0 || line.hasOption('d') || line.hasOption('b') && line.hasOption('s') && !line.hasOption('g') && !line.hasOption('m') && !line.hasOption('y')) {
            System.err.println("Nothing to do (no sitemap to generate)");
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (!line.hasOption('b') || !line.hasOption('s')) {
            GenerateSitemaps.generateSitemaps(!line.hasOption('b'), !line.hasOption('s'));
        }
        if (line.hasOption('d')) {
            GenerateSitemaps.deleteSitemaps();
        }
        System.exit(0);
    }

    public static void generateSitemapsScheduled() throws IOException, SQLException {
        GenerateSitemaps.generateSitemaps(true, true);
    }

    public static void deleteSitemaps() throws IOException {
        File outputDir = new File(configurationService.getProperty("sitemap.dir"));
        if (!outputDir.exists() && !outputDir.isDirectory()) {
            log.error("Unable to delete sitemaps directory, doesn't exist or isn't a directort");
        } else {
            FileUtils.deleteDirectory((File)outputDir);
        }
    }

    public static void generateSitemaps(boolean makeHTMLMap, boolean makeSitemapOrg) throws SQLException, IOException {
        Object uiURLStem = configurationService.getProperty("dspace.ui.url");
        if (!((String)uiURLStem).endsWith("/")) {
            uiURLStem = (String)uiURLStem + "/";
        }
        String sitemapStem = (String)uiURLStem + "sitemap";
        File outputDir = new File(configurationService.getProperty("sitemap.dir"));
        if (!outputDir.exists() && !outputDir.mkdir()) {
            log.error("Unable to create output directory");
        }
        HTMLSitemapGenerator html = null;
        SitemapsOrgGenerator sitemapsOrg = null;
        if (makeHTMLMap) {
            html = new HTMLSitemapGenerator(outputDir, sitemapStem, ".html");
        }
        if (makeSitemapOrg) {
            sitemapsOrg = new SitemapsOrgGenerator(outputDir, sitemapStem, ".xml");
        }
        Context c = new Context(Context.Mode.READ_ONLY);
        int offset = 0;
        long commsCount = 0L;
        long collsCount = 0L;
        long itemsCount = 0L;
        try {
            String url;
            List<IndexableObject> docs;
            DiscoverResult discoverResult;
            DiscoverQuery discoveryQuery = new DiscoverQuery();
            discoveryQuery.setMaxResults(100);
            discoveryQuery.setQuery("search.resourcetype:Community");
            do {
                discoveryQuery.setStart(offset);
                discoverResult = searchService.search(c, discoveryQuery);
                docs = discoverResult.getIndexableObjects();
                commsCount = discoverResult.getTotalSearchResults();
                for (IndexableObject doc : docs) {
                    url = (String)uiURLStem + "communities/" + doc.getID();
                    c.uncacheEntity(doc.getIndexedObject());
                    if (makeHTMLMap) {
                        html.addURL(url, null);
                    }
                    if (!makeSitemapOrg) continue;
                    sitemapsOrg.addURL(url, null);
                }
            } while ((long)(offset += 100) < commsCount);
            offset = 0;
            discoveryQuery = new DiscoverQuery();
            discoveryQuery.setMaxResults(100);
            discoveryQuery.setQuery("search.resourcetype:Collection");
            do {
                discoveryQuery.setStart(offset);
                discoverResult = searchService.search(c, discoveryQuery);
                docs = discoverResult.getIndexableObjects();
                collsCount = discoverResult.getTotalSearchResults();
                for (IndexableObject doc : docs) {
                    url = (String)uiURLStem + "collections/" + doc.getID();
                    c.uncacheEntity(doc.getIndexedObject());
                    if (makeHTMLMap) {
                        html.addURL(url, null);
                    }
                    if (!makeSitemapOrg) continue;
                    sitemapsOrg.addURL(url, null);
                }
            } while ((long)(offset += 100) < collsCount);
            offset = 0;
            discoveryQuery = new DiscoverQuery();
            discoveryQuery.setMaxResults(100);
            discoveryQuery.setQuery("search.resourcetype:Item");
            discoveryQuery.addSearchField("search.entitytype");
            do {
                discoveryQuery.setStart(offset);
                discoverResult = searchService.search(c, discoveryQuery);
                docs = discoverResult.getIndexableObjects();
                itemsCount = discoverResult.getTotalSearchResults();
                for (IndexableObject doc : docs) {
                    List<String> entityTypeFieldValues = discoverResult.getSearchDocument(doc).get(0).getSearchFieldValues("search.entitytype");
                    url = CollectionUtils.isNotEmpty(entityTypeFieldValues) ? (String)uiURLStem + "entities/" + StringUtils.lowerCase((String)entityTypeFieldValues.get(0)) + "/" + doc.getID() : (String)uiURLStem + "items/" + doc.getID();
                    Date lastMod = doc.getLastModified();
                    c.uncacheEntity(doc.getIndexedObject());
                    if (makeHTMLMap) {
                        html.addURL(url, null);
                    }
                    if (!makeSitemapOrg) continue;
                    sitemapsOrg.addURL(url, null);
                }
            } while ((long)(offset += 100) < itemsCount);
            if (makeHTMLMap) {
                int files = html.finish();
                log.info(LogHelper.getHeader(c, "write_sitemap", "type=html,num_files=" + files + ",communities=" + commsCount + ",collections=" + collsCount + ",items=" + itemsCount));
            }
            if (makeSitemapOrg) {
                int files = sitemapsOrg.finish();
                log.info(LogHelper.getHeader(c, "write_sitemap", "type=html,num_files=" + files + ",communities=" + commsCount + ",collections=" + collsCount + ",items=" + itemsCount));
            }
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            c.abort();
        }
    }
}

