/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class PasswordAuthentication
implements AuthenticationMethod {
    private static final Logger log = LogManager.getLogger();
    private static final String PASSWORD_AUTHENTICATED = "password.authenticated";
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String email) throws SQLException {
        String[] domains = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("authentication-password.domain.valid");
        if (domains == null || domains.length == 0) {
            return true;
        }
        email = email.trim().toLowerCase();
        for (int i = 0; i < domains.length; ++i) {
            String check = domains[i].trim().toLowerCase();
            if (!email.endsWith(check)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return true;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            String groupName;
            if (context.getCurrentUser() != null && StringUtils.isNotBlank((CharSequence)EPersonServiceFactory.getInstance().getEPersonService().getPasswordHash(context.getCurrentUser()).toString()) && (groupName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("authentication-password.login.specialgroup")) != null && !groupName.trim().isEmpty()) {
                Group specialGroup = EPersonServiceFactory.getInstance().getGroupService().findByName(context, groupName);
                if (specialGroup == null) {
                    log.warn(LogHelper.getHeader(context, "password_specialgroup", "Group defined in modules/authentication-password.cfg login.specialgroup does not exist"));
                    return Collections.EMPTY_LIST;
                }
                return Arrays.asList(specialGroup);
            }
        }
        catch (Exception e) {
            log.error(LogHelper.getHeader(context, "getSpecialGroups", ""), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (username != null && password != null) {
            EPerson eperson = null;
            log.info(LogHelper.getHeader(context, "authenticate", "attempting password auth of user=" + username));
            eperson = EPersonServiceFactory.getInstance().getEPersonService().findByEmail(context, username.toLowerCase());
            if (eperson == null) {
                return 4;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (eperson.getRequireCertificate()) {
                log.warn(LogHelper.getHeader(context, "authenticate", "rejecting PasswordAuthentication because " + username + " requires certificate."));
                return 3;
            }
            if (EPersonServiceFactory.getInstance().getEPersonService().checkPassword(context, eperson, password)) {
                context.setCurrentUser(eperson);
                if (request != null) {
                    request.setAttribute(PASSWORD_AUTHENTICATED, (Object)true);
                }
                log.info(LogHelper.getHeader(context, "authenticate", "type=PasswordAuthentication"));
                return 1;
            }
            return 2;
        }
        return 5;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Override
    public String getName() {
        return "password";
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request != null && context.getCurrentUser() != null && request.getAttribute(PASSWORD_AUTHENTICATED) != null;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        if (context == null || ePerson == null) {
            return false;
        }
        return this.ePersonService.checkPassword(context, ePerson, currentPassword);
    }
}

