/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XSLTCrosswalk
extends SelfNamedPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(XSLTCrosswalk.class);
    public static final Namespace DIM_NS = Namespace.getNamespace((String)"dim", (String)"http://www.dspace.org/xmlns/dspace/dim");
    protected static final String CONFIG_PREFIX = "crosswalk.";
    private static final String CONFIG_STYLESHEET = ".stylesheet";
    private Transformer transformer = null;
    private File transformFile = null;
    private long transformLastModified = 0L;

    protected static String[] makeAliases(String direction) {
        String prefix = CONFIG_PREFIX + direction + ".";
        String suffix = CONFIG_STYLESHEET;
        ArrayList<String> aliasList = new ArrayList<String>();
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        List configKeys = configurationService.getPropertyKeys(prefix);
        LOG.debug("XSLTCrosswalk: Looking for config prefix = {}", (Object)prefix);
        for (String key : configKeys) {
            if (!key.endsWith(suffix)) continue;
            LOG.debug("Getting XSLT plugin name from config line: {}", (Object)key);
            aliasList.add(key.substring(prefix.length(), key.length() - suffix.length()));
        }
        return aliasList.toArray(new String[aliasList.size()]);
    }

    protected Transformer getTransformer(String direction) {
        if (this.transformFile == null) {
            String myAlias = this.getPluginInstanceName();
            if (myAlias == null) {
                LOG.error("Must use PluginService to instantiate XSLTCrosswalk so the class knows its name.");
                return null;
            }
            String cmPropName = CONFIG_PREFIX + direction + "." + myAlias + CONFIG_STYLESHEET;
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            String fname = configurationService.getProperty(cmPropName);
            if (fname == null) {
                LOG.error("Missing configuration filename for XSLT-based crosswalk: no value for property = {}", (Object)cmPropName);
                return null;
            }
            String parent = configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator;
            this.transformFile = new File(parent, fname);
        }
        if (this.transformer == null || this.transformFile.lastModified() > this.transformLastModified) {
            try {
                LOG.debug(this.transformer == null ? "Loading {} XSLT stylesheet from {}" : "Reloading {} XSLT stylesheet from {}", (Object)this.getPluginInstanceName(), (Object)this.transformFile.toString());
                StreamSource transformSource = new StreamSource(new FileInputStream(this.transformFile));
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                this.transformer = transformerFactory.newTransformer(transformSource);
                this.transformLastModified = this.transformFile.lastModified();
            }
            catch (FileNotFoundException | TransformerConfigurationException e) {
                LOG.error("Failed to initialize XSLTCrosswalk({}):  {}", (Object)this.getPluginInstanceName(), (Object)e.toString());
            }
        }
        return this.transformer;
    }
}

