/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.curate.ResolvedTask;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.curate.TaskResolver;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;

public class Curator {
    public static final int CURATE_NOTASK = -3;
    public static final int CURATE_UNSET = -2;
    public static final int CURATE_ERROR = -1;
    public static final int CURATE_SUCCESS = 0;
    public static final int CURATE_FAIL = 1;
    public static final int CURATE_SKIP = 2;
    private static final Logger log = LogManager.getLogger();
    protected static final ThreadLocal<Context> curationCtx = new ThreadLocal();
    protected final Map<String, String> runParameters = new HashMap<String, String>();
    protected Map<String, TaskRunner> trMap = new HashMap<String, TaskRunner>();
    protected List<String> perfList = new ArrayList<String>();
    protected TaskQueue taskQ = null;
    protected Appendable reporter = null;
    protected Invoked iMode = null;
    protected TaskResolver resolver = new TaskResolver();
    protected TxScope txScope = TxScope.OPEN;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected DSpaceRunnableHandler handler;

    public Curator(DSpaceRunnableHandler handler) {
        this();
        this.handler = handler;
    }

    public Curator() {
        this.resolver = new TaskResolver();
    }

    public void addParameter(String name, String value) {
        this.runParameters.put(name, value);
    }

    public void addParameters(Map<String, String> parameters) {
        this.runParameters.putAll(parameters);
    }

    public String getRunParameter(String name) {
        return this.runParameters.get(name);
    }

    public Curator addTask(String taskName) {
        ResolvedTask task = this.resolver.resolveTask(taskName);
        if (task != null) {
            try {
                task.init(this);
                this.trMap.put(taskName, new TaskRunner(task));
                this.perfList.add(taskName);
            }
            catch (IOException ioE) {
                System.out.println("Task: '" + taskName + "' initialization failure: " + ioE.getMessage());
            }
        } else {
            System.out.println("Task: '" + taskName + "' does not resolve");
        }
        return this;
    }

    public boolean hasTask(String taskName) {
        return this.perfList.contains(taskName);
    }

    public Curator removeTask(String taskName) {
        this.trMap.remove(taskName);
        this.perfList.remove(taskName);
        return this;
    }

    public Curator setInvoked(Invoked mode) {
        this.iMode = mode;
        return this;
    }

    public Curator setReporter(Appendable reporter) {
        this.reporter = reporter;
        return this;
    }

    public Curator setTransactionScope(TxScope scope) {
        this.txScope = scope;
        return this;
    }

    public void curate(Context c, String id) throws IOException {
        if (id == null) {
            throw new IOException("Cannot perform curation task(s) on a null object identifier!");
        }
        try {
            Context ctx;
            curationCtx.set(c);
            DSpaceObject dso = this.handleService.resolveToObject(c, id);
            if (dso != null) {
                this.curate(dso);
            } else {
                for (String taskName : this.perfList) {
                    this.trMap.get(taskName).run(c, id);
                }
            }
            if (this.txScope.equals((Object)TxScope.CURATION) && (ctx = curationCtx.get()) != null) {
                ctx.complete();
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        finally {
            curationCtx.remove();
        }
    }

    public void curate(DSpaceObject dso) throws IOException {
        if (dso == null) {
            throw new IOException("Cannot perform curation task(s) on a null DSpaceObject!");
        }
        int type = dso.getType();
        for (String taskName : this.perfList) {
            TaskRunner tr = this.trMap.get(taskName);
            if (type == 2 || tr.task.isDistributive()) {
                tr.run(dso);
                continue;
            }
            if (type == 3) {
                this.doCollection(tr, (Collection)dso);
                continue;
            }
            if (type == 4) {
                this.doCommunity(tr, (Community)dso);
                continue;
            }
            if (type != 5) continue;
            this.doSite(tr, (Site)dso);
        }
    }

    public void curate(Context c, DSpaceObject dso) throws IOException {
        curationCtx.set(c);
        this.curate(dso);
    }

    public void queue(Context c, String id, String queueId) throws IOException {
        if (this.taskQ == null) {
            this.taskQ = (TaskQueue)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(TaskQueue.class);
        }
        if (this.taskQ != null) {
            this.taskQ.enqueue(queueId, new TaskQueueEntry(c.getCurrentUser().getName(), System.currentTimeMillis(), this.perfList, id));
        } else {
            System.out.println("curate - no TaskQueue implemented");
        }
    }

    public void clear() {
        this.trMap.clear();
        this.perfList.clear();
    }

    public void report(String message) {
        if (null == this.reporter) {
            this.logWarning("report called with no Reporter set:  {}", message);
            return;
        }
        try {
            this.reporter.append(message);
        }
        catch (IOException ex) {
            System.out.println("Task reporting failure: " + ex);
        }
    }

    public int getStatus(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.statusCode : -3;
    }

    public String getResult(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.result : null;
    }

    public void setResult(String taskName, String result) {
        TaskRunner tr = this.trMap.get(taskName);
        if (tr != null) {
            tr.setResult(result);
        }
    }

    public static Context curationContext() throws SQLException {
        Context curCtx = curationCtx.get();
        if (curCtx == null || !curCtx.isValid()) {
            curCtx = new Context();
            curationCtx.set(curCtx);
        }
        return curCtx;
    }

    public static boolean isContainer(DSpaceObject dso) {
        return dso.getType() == 4 || dso.getType() == 3;
    }

    protected boolean doSite(TaskRunner tr, Site site) throws IOException {
        Context ctx = null;
        try {
            ctx = Curator.curationContext();
            if (ctx.getCurrentUser() == null && !ctx.ignoreAuthorization()) {
                this.logWarning("You are running one or more Site-Wide curation tasks in ANONYMOUS USER mode, as there is no EPerson 'performer' associated with this task. To associate an EPerson 'performer'  you should ensure tasks are called via the Curator.curate(Context, ID) method.");
            }
            if (!tr.run(site)) {
                return false;
            }
            for (Community subcomm : this.communityService.findAllTop(ctx)) {
                if (this.doCommunity(tr, subcomm)) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        return true;
    }

    protected boolean doCommunity(TaskRunner tr, Community comm) throws IOException {
        if (!tr.run(comm)) {
            return false;
        }
        for (Community subcomm : comm.getSubcommunities()) {
            if (this.doCommunity(tr, subcomm)) continue;
            return false;
        }
        for (Collection coll : comm.getCollections()) {
            if (this.doCollection(tr, coll)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCollection(TaskRunner tr, Collection coll) throws IOException {
        try {
            if (!tr.run(coll)) {
                return false;
            }
            Context context = Curator.curationContext();
            Iterator<Item> iter = this.itemService.findByCollection(context, coll);
            while (iter.hasNext()) {
                Item item = iter.next();
                boolean shouldContinue = tr.run(item);
                context.uncacheEntity(item);
                if (shouldContinue) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        return true;
    }

    protected void visit(DSpaceObject dso) throws IOException {
        Context curCtx = curationCtx.get();
        if (curCtx != null && this.txScope.equals((Object)TxScope.OBJECT)) {
            curCtx.dispatchEvents();
        }
    }

    protected void logWarning(String message) {
        this.logWarning(message, null);
    }

    protected void logWarning(String message, Object object) {
        if (this.handler == null) {
            if (object != null) {
                log.warn(message, object);
            } else {
                log.warn(message);
            }
        } else if (object != null) {
            this.handler.logWarning(MessageFormat.format(message, object));
        } else {
            this.handler.logWarning(message);
        }
    }

    protected class TaskRunner {
        ResolvedTask task = null;
        int statusCode = -2;
        String result = null;

        public TaskRunner(ResolvedTask task) {
            this.task = task;
        }

        public boolean run(DSpaceObject dso) throws IOException {
            try {
                if (dso == null) {
                    throw new IOException("DSpaceObject is null");
                }
                this.statusCode = this.task.perform(dso);
                Object id = dso.getHandle() != null ? dso.getHandle() : "workflow item: " + dso.getID();
                this.logInfo(this.logMessage((String)id));
                Curator.this.visit(dso);
                return !this.suspend(this.statusCode);
            }
            catch (IOException ioe) {
                System.out.println("Error executing curation task '" + this.task.getName() + "'; " + ioe);
                throw ioe;
            }
        }

        public boolean run(Context c, String id) throws IOException {
            try {
                if (c == null || id == null) {
                    throw new IOException("Context or identifier is null");
                }
                this.statusCode = this.task.perform(c, id);
                this.logInfo(this.logMessage(id));
                Curator.this.visit(null);
                return !this.suspend(this.statusCode);
            }
            catch (IOException ioe) {
                System.out.println("Error executing curation task '" + this.task.getName() + "'; " + ioe);
                throw ioe;
            }
        }

        public void setResult(String result) {
            this.result = result;
        }

        protected boolean suspend(int code) {
            Invoked mode = this.task.getMode();
            if (mode != null && (mode.equals((Object)Invoked.ANY) || mode.equals((Object)Curator.this.iMode))) {
                for (int i : this.task.getCodes()) {
                    if (code != i) continue;
                    return true;
                }
            }
            return false;
        }

        protected String logMessage(String id) {
            StringBuilder mb = new StringBuilder();
            mb.append("Curation task: ").append(this.task.getName()).append(" performed on: ").append(id).append(" with status: ").append(this.statusCode);
            if (this.result != null) {
                mb.append(". Result: '").append(this.result).append("'");
            }
            return mb.toString();
        }

        protected void logInfo(String message) {
            if (Curator.this.handler == null) {
                log.info(message);
            } else {
                Curator.this.handler.logInfo(message);
            }
        }
    }

    public static enum TxScope {
        OBJECT,
        CURATION,
        OPEN;

    }

    public static enum Invoked {
        INTERACTIVE,
        BATCH,
        ANY;

    }
}

