/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.GoogleAnalyticsClient;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleAsyncEventListener
extends AbstractUsageEventListener {
    public static final int GA_MAX_EVENTS = 20;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_TIME_SINCE_EVENT = 14400000;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ClientInfoService clientInfoService;
    @Autowired
    private List<GoogleAnalyticsClient> googleAnalyticsClients;
    private Buffer eventsBuffer;

    @PostConstruct
    public void init() {
        int analyticsBufferlimit = this.configurationService.getIntProperty("google.analytics.buffer.limit", 256);
        this.eventsBuffer = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(analyticsBufferlimit));
    }

    public void receiveEvent(Event event) {
        if (!(event instanceof UsageEvent) || this.isGoogleAnalyticsKeyNotConfigured()) {
            return;
        }
        UsageEvent usageEvent = (UsageEvent)event;
        LOGGER.debug("Usage event received " + event.getName());
        if (!this.isContentBitstream(usageEvent)) {
            return;
        }
        try {
            GoogleAnalyticsEvent analyticsEvent = this.createGoogleAnalyticsEvent(usageEvent);
            this.eventsBuffer.add((Object)analyticsEvent);
        }
        catch (Exception e) {
            this.logReceiveEventException(usageEvent, e);
        }
    }

    public void sendCollectedEvents() {
        if (this.isGoogleAnalyticsKeyNotConfigured()) {
            return;
        }
        String analyticsKey = this.getGoogleAnalyticsKey();
        List<GoogleAnalyticsEvent> events = this.getEventsFromBufferFilteredByEventTime();
        if (events.isEmpty()) {
            return;
        }
        GoogleAnalyticsClient client = this.getClientByAnalyticsKey(analyticsKey);
        try {
            client.sendEvents(analyticsKey, events);
        }
        catch (RuntimeException ex) {
            LOGGER.error("An error occurs sending the events.", (Throwable)ex);
        }
    }

    private GoogleAnalyticsEvent createGoogleAnalyticsEvent(UsageEvent usageEvent) {
        HttpServletRequest request = usageEvent.getRequest();
        String clientId = this.getClientId(usageEvent);
        String referrer = this.getReferrer(usageEvent);
        String clientIp = this.clientInfoService.getClientIp(request);
        String userAgent = request.getHeader("USER-AGENT");
        String documentPath = this.getDocumentPath(request);
        String documentName = this.getObjectName(usageEvent);
        return new GoogleAnalyticsEvent(clientId, clientIp, userAgent, referrer, documentPath, documentName);
    }

    private String getClientId(UsageEvent usageEvent) {
        if (usageEvent.getRequest().getHeader("X-CORRELATION-ID") != null) {
            return usageEvent.getRequest().getHeader("X-CORRELATION-ID");
        }
        if (usageEvent.getRequest().getSession(false) != null) {
            return usageEvent.getRequest().getSession().getId();
        }
        return UUID.randomUUID().toString();
    }

    private String getReferrer(UsageEvent usageEvent) {
        if (usageEvent.getRequest().getHeader("X-REFERRER") != null) {
            return usageEvent.getRequest().getHeader("X-REFERRER");
        }
        return usageEvent.getRequest().getHeader("referer");
    }

    private String getDocumentPath(HttpServletRequest request) {
        Object documentPath = request.getRequestURI();
        if (StringUtils.isNotBlank((String)request.getQueryString())) {
            documentPath = (String)documentPath + "?" + request.getQueryString();
        }
        return documentPath;
    }

    private boolean isContentBitstream(UsageEvent usageEvent) {
        if (usageEvent.getAction() == UsageEvent.Action.VIEW && usageEvent.getObject().getType() == 0) {
            List bitstreamBundles;
            List<String> allowedBundles = List.of(this.configurationService.getArrayProperty("google-analytics.bundles", new String[]{"ORIGINAL"}));
            if (allowedBundles.contains("none")) {
                return false;
            }
            try {
                bitstreamBundles = ((Bitstream)usageEvent.getObject()).getBundles().stream().map(Bundle::getName).collect(Collectors.toList());
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return allowedBundles.stream().anyMatch(bitstreamBundles::contains);
        }
        return false;
    }

    private boolean isGoogleAnalyticsKeyNotConfigured() {
        return StringUtils.isBlank((String)this.getGoogleAnalyticsKey());
    }

    private void logReceiveEventException(UsageEvent usageEvent, Exception e) {
        LOGGER.error("Failed to add event to buffer", (Throwable)e);
        LOGGER.error("Event information: " + usageEvent);
        Context context = usageEvent.getContext();
        if (context == null) {
            LOGGER.error("UsageEvent has no Context object");
            return;
        }
        LOGGER.error("Context information:");
        LOGGER.error("    Current User: " + context.getCurrentUser());
        LOGGER.error("    Extra log info: " + context.getExtraLogInfo());
        if (context.getEvents() != null && !context.getEvents().isEmpty()) {
            for (int x = 1; x <= context.getEvents().size(); ++x) {
                LOGGER.error("    Context Event " + x + ": " + context.getEvents().get(x));
            }
        }
    }

    private String getObjectName(UsageEvent ue) {
        try {
            if (ue.getObject().getType() == 0) {
                return ContentServiceFactory.getInstance().getDSpaceObjectService(ue.getObject()).getParentObject(ue.getContext(), ue.getObject()).getName();
            }
            return ue.getObject().getName();
        }
        catch (SQLException e) {
            LOGGER.error("Error in Google Analytics recording - can't determine ParentObjectName for bitstream " + ue.getObject().getID(), (Throwable)e);
            return null;
        }
    }

    private List<GoogleAnalyticsEvent> getEventsFromBufferFilteredByEventTime() {
        ArrayList<GoogleAnalyticsEvent> events = new ArrayList<GoogleAnalyticsEvent>();
        Iterator iterator = this.eventsBuffer.iterator();
        while (iterator.hasNext() && events.size() < 20) {
            GoogleAnalyticsEvent event = (GoogleAnalyticsEvent)iterator.next();
            this.eventsBuffer.remove((Object)event);
            if (System.currentTimeMillis() - event.getTime() >= 14400000L) continue;
            events.add(event);
        }
        return events;
    }

    private GoogleAnalyticsClient getClientByAnalyticsKey(String analyticsKey) {
        List clients = this.googleAnalyticsClients.stream().filter(client -> client.isAnalyticsKeySupported(analyticsKey)).collect(Collectors.toList());
        if (clients.isEmpty()) {
            throw new IllegalStateException("No Google Analytics Client supports key " + analyticsKey);
        }
        if (clients.size() > 1) {
            throw new IllegalStateException("More than one Google Analytics Client supports key " + analyticsKey);
        }
        return (GoogleAnalyticsClient)clients.get(0);
    }

    private String getGoogleAnalyticsKey() {
        return this.configurationService.getProperty("google.analytics.key");
    }

    public List<GoogleAnalyticsClient> getGoogleAnalyticsClients() {
        return this.googleAnalyticsClients;
    }

    public void setGoogleAnalyticsClients(List<GoogleAnalyticsClient> googleAnalyticsClients) {
        this.googleAnalyticsClients = googleAnalyticsClients;
    }

    public Buffer getEventsBuffer() {
        return this.eventsBuffer;
    }
}

