/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HandleIdentifierProvider
extends IdentifierProvider {
    private static final Logger log = LogManager.getLogger(HandleIdentifierProvider.class);
    protected static final String EXAMPLE_PREFIX = "123456789";
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        return this.handleService.parseHandle(identifier) != null;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        try {
            String id = this.mint(context, dso);
            if (dso instanceof Item || dso instanceof Collection || dso instanceof Community) {
                this.populateHandleMetadata(context, dso, id);
            }
            return id;
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
            if (dso instanceof Item || dso instanceof Collection || dso instanceof Community) {
                this.populateHandleMetadata(context, dso, identifier);
            }
        }
        catch (IOException | IllegalStateException | SQLException | AuthorizeException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
        }
        catch (IllegalStateException | SQLException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            return this.handleService.createHandle(context, dso);
        }
        catch (SQLException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            identifier = this.handleService.parseHandle(identifier);
            return this.handleService.resolveToObject(context, identifier);
        }
        catch (IllegalStateException | SQLException e) {
            log.error(LogHelper.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
            return null;
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            return this.handleService.findHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            this.handleService.unbindHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierException(sqe.getMessage(), sqe);
        }
    }

    public static String retrieveHandleOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String prefix = configurationService.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error("handle.prefix is not configured; using " + prefix);
        }
        return prefix;
    }

    protected void populateHandleMetadata(Context context, DSpaceObject dso, String handle) throws SQLException, IOException, AuthorizeException {
        String handleref = this.handleService.getCanonicalForm(handle);
        DSpaceObjectService<DSpaceObject> dsoService = this.contentServiceFactory.getDSpaceObjectService(dso);
        boolean identifierExists = false;
        List<MetadataValue> identifiers = dsoService.getMetadata(dso, MetadataSchemaEnum.DC.getName(), "identifier", "uri", "*");
        for (MetadataValue identifier : identifiers) {
            if (!handleref.equals(identifier.getValue())) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            dsoService.addMetadata(context, dso, MetadataSchemaEnum.DC.getName(), "identifier", "uri", null, handleref);
        }
    }
}

