/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.wos.service;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.MethodNotFoundException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.DoiCheck;
import org.dspace.importer.external.service.components.QuerySource;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WOSImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private static final String AI_PATTERN = "^AI=(.*)";
    private static final Pattern ISI_PATTERN = Pattern.compile("^\\d{15}$");
    private int timeout = 1000;
    private String url;
    private String urlSearch;
    private String apiKey;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getImportSource() {
        return "wos";
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByQueryCallable(query));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new FindByIdCallable(id));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new SearchNBByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for WOS");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for WOS");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for WOS");
    }

    private Map<String, String> getRequestParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Accept", "application/xml");
        params.put("X-ApiKey", this.apiKey);
        return params;
    }

    private String checkQuery(String query) {
        Pattern risPattern = Pattern.compile(AI_PATTERN);
        Matcher risMatcher = risPattern.matcher(query.trim());
        if (risMatcher.matches()) {
            return query;
        }
        if (DoiCheck.isDoi(query)) {
            if (query.startsWith(",")) {
                query = query.substring(1);
            }
            return "DO=(" + query + ")";
        }
        if (this.isIsi(query)) {
            return "UT=(" + query + ")";
        }
        StringBuilder queryBuilder = new StringBuilder("TS=(");
        queryBuilder.append(query).append(")");
        return queryBuilder.toString();
    }

    private boolean isIsi(String query) {
        if (query.startsWith("WOS:")) {
            return true;
        }
        Matcher matcher = ISI_PATTERN.matcher(query.trim());
        return matcher.matches();
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            String cData = ((Element)XPathFactory.instance().compile("//*[@name=\"Records\"]", Filters.element(), null, new Namespace[0]).evaluate((Object)root).get(0)).getValue().trim();
            Document intDocument = saxBuilder.build((Reader)new StringReader(cData));
            XPathExpression xPath = XPathFactory.instance().compile("*", Filters.element(), null, new Namespace[0]);
            List records = xPath.evaluate((Object)intDocument.getRootElement());
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                return records;
            }
        }
        catch (IOException | JDOMException e) {
            log.error(e.getMessage());
            return new ArrayList<Element>();
        }
        return new ArrayList<Element>();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlSearch() {
        return this.urlSearch;
    }

    public void setUrlSearch(String urlSearch) {
        this.urlSearch = urlSearch;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", maxResult);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String queryString = WOSImportMetadataSourceServiceImpl.this.checkQuery(this.query.getParameterAsClass("query", String.class));
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            if (StringUtils.isNotBlank((CharSequence)WOSImportMetadataSourceServiceImpl.this.apiKey)) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                params.put("headerParameters", WOSImportMetadataSourceServiceImpl.this.getRequestParameters());
                String url = WOSImportMetadataSourceServiceImpl.this.urlSearch + URLEncoder.encode(queryString, StandardCharsets.UTF_8) + "&count=" + count + "&firstRecord=" + (start + 1);
                String response = WOSImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(WOSImportMetadataSourceServiceImpl.this.timeout, url, params);
                List<Element> omElements = WOSImportMetadataSourceServiceImpl.this.splitToRecords(response);
                for (Element el : omElements) {
                    results.add(WOSImportMetadataSourceServiceImpl.this.transformSourceRecords(el));
                }
            }
            return results;
        }
    }

    private class FindByIdCallable
    implements Callable<List<ImportRecord>> {
        private String doi;

        private FindByIdCallable(String doi) {
            this.doi = URLEncoder.encode(doi, StandardCharsets.UTF_8);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            if (StringUtils.isNotBlank((CharSequence)WOSImportMetadataSourceServiceImpl.this.apiKey)) {
                String urlString = WOSImportMetadataSourceServiceImpl.this.url + this.doi + "?databaseId=WOS&lang=en&count=10&firstRecord=1";
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                params.put("headerParameters", WOSImportMetadataSourceServiceImpl.this.getRequestParameters());
                String response = WOSImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(WOSImportMetadataSourceServiceImpl.this.timeout, urlString, params);
                List<Element> elements = WOSImportMetadataSourceServiceImpl.this.splitToRecords(response);
                for (Element record : elements) {
                    results.add(WOSImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
            }
            return results;
        }
    }

    private class SearchNBByQueryCallable
    implements Callable<Integer> {
        private String query;

        private SearchNBByQueryCallable(String queryString) {
            this.query = queryString;
        }

        private SearchNBByQueryCallable(Query query) {
            this.query = query.getParameterAsClass("query", String.class);
        }

        @Override
        public Integer call() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)WOSImportMetadataSourceServiceImpl.this.apiKey)) {
                String queryString = URLEncoder.encode(WOSImportMetadataSourceServiceImpl.this.checkQuery(this.query), StandardCharsets.UTF_8);
                String url = WOSImportMetadataSourceServiceImpl.this.urlSearch + queryString + "&count=1&firstRecord=1";
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                params.put("headerParameters", WOSImportMetadataSourceServiceImpl.this.getRequestParameters());
                String response = WOSImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(WOSImportMetadataSourceServiceImpl.this.timeout, url, params);
                SAXBuilder saxBuilder = new SAXBuilder();
                saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document document = saxBuilder.build((Reader)new StringReader(response));
                Element root = document.getRootElement();
                XPathExpression xpath = XPathFactory.instance().compile("//*[@name=\"RecordsFound\"]", Filters.element(), null, new Namespace[0]);
                Element tot = (Element)xpath.evaluateFirst((Object)root);
                return Integer.valueOf(tot.getValue());
            }
            return null;
        }
    }
}

